@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.inputs

import com.pulumi.azurenative.alertsmanagement.inputs.ScopeArgs.builder
import com.pulumi.azurenative.alertsmanagement.kotlin.enums.ScopeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Target scope for a given action rule. By default scope will be the subscription. User can also provide list of resource groups or list of resources from the scope subscription as well.
 * @property scopeType type of target scope
 * @property values list of ARM IDs of the given scope type which will be the target of the given action rule.
 */
public data class ScopeArgs(
    public val scopeType: Output<Either<String, ScopeType>>? = null,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.alertsmanagement.inputs.ScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.alertsmanagement.inputs.ScopeArgs =
        com.pulumi.azurenative.alertsmanagement.inputs.ScopeArgs.builder()
            .scopeType(
                scopeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ScopeArgs].
 */
@PulumiTagMarker
public class ScopeArgsBuilder internal constructor() {
    private var scopeType: Output<Either<String, ScopeType>>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value type of target scope
     */
    @JvmName("sevddmdcuplbfiue")
    public suspend fun scopeType(`value`: Output<Either<String, ScopeType>>) {
        this.scopeType = value
    }

    /**
     * @param value list of ARM IDs of the given scope type which will be the target of the given action rule.
     */
    @JvmName("naaxsqlbtxxyysbh")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("vornxpcijubkikmm")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values list of ARM IDs of the given scope type which will be the target of the given action rule.
     */
    @JvmName("kxjxxthiaduoafoe")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value type of target scope
     */
    @JvmName("wtusldogfsdceacs")
    public suspend fun scopeType(`value`: Either<String, ScopeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeType = mapped
    }

    /**
     * @param value type of target scope
     */
    @JvmName("pestxlpjluapmypd")
    public fun scopeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopeType = mapped
    }

    /**
     * @param value type of target scope
     */
    @JvmName("cpiplgcbrhxpscyp")
    public fun scopeType(`value`: ScopeType) {
        val toBeMapped = Either.ofRight<String, ScopeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopeType = mapped
    }

    /**
     * @param value list of ARM IDs of the given scope type which will be the target of the given action rule.
     */
    @JvmName("fgadkxdogybuddxy")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values list of ARM IDs of the given scope type which will be the target of the given action rule.
     */
    @JvmName("pghinbjtwsoxfdrb")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ScopeArgs = ScopeArgs(
        scopeType = scopeType,
        values = values,
    )
}
