@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Suppress

/**
 * Conditions in alert instance to be matched for a given action rule. Default value is all. Multiple values could be provided with comma separation.
 * @property alertContext filter alerts by alert context (payload)
 * @property alertRuleId filter alerts by alert rule id
 * @property alertRuleName filter alerts by alert rule name
 * @property description filter alerts by alert rule description
 * @property monitorCondition filter alerts by monitor condition
 * @property monitorService filter alerts by monitor service
 * @property severity filter alerts by severity
 * @property targetResourceType filter alerts by target resource type
 */
public data class ConditionsResponse(
    public val alertContext: ConditionResponse? = null,
    public val alertRuleId: ConditionResponse? = null,
    public val alertRuleName: ConditionResponse? = null,
    public val description: ConditionResponse? = null,
    public val monitorCondition: ConditionResponse? = null,
    public val monitorService: ConditionResponse? = null,
    public val severity: ConditionResponse? = null,
    public val targetResourceType: ConditionResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.ConditionsResponse):
            ConditionsResponse = ConditionsResponse(
            alertContext = javaType.alertContext().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            alertRuleId = javaType.alertRuleId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            alertRuleName = javaType.alertRuleName().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            monitorCondition = javaType.monitorCondition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            monitorService = javaType.monitorService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            severity = javaType.severity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetResourceType = javaType.targetResourceType().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
