@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Add logic for alerts correlation.
 * @property actionType Action that should be applied.
 * Expected value is 'CorrelateAlerts'.
 * @property correlateBy The list of conditions for the alerts correlations.
 * @property correlationInterval The required duration (in ISO8601 format) for the alerts correlation.
 * @property notificationsForCorrelatedAlerts Indicates how to handle child alerts notifications.
 * @property priority The priority of this correlation.
 */
public data class CorrelateAlertsResponse(
    public val actionType: String,
    public val correlateBy: List<CorrelateByResponse>,
    public val correlationInterval: String,
    public val notificationsForCorrelatedAlerts: String? = null,
    public val priority: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.CorrelateAlertsResponse):
            CorrelateAlertsResponse = CorrelateAlertsResponse(
            actionType = javaType.actionType(),
            correlateBy = javaType.correlateBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.CorrelateByResponse.Companion.toKotlin(args0)
                })
            }),
            correlationInterval = javaType.correlationInterval(),
            notificationsForCorrelatedAlerts = javaType.notificationsForCorrelatedAlerts().map({ args0 ->
                args0
            }).orElse(null),
            priority = javaType.priority(),
        )
    }
}
