@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The alert rule information
 * @property actionGroups The alert rule actions.
 * @property description The alert rule description.
 * @property detector The alert rule's detector.
 * @property frequency The alert rule frequency in ISO8601 format. The time granularity must be in minutes and minimum value is 1 minute, depending on the detector.
 * @property id The resource ID.
 * @property location The resource location.
 * @property name The resource name.
 * @property scope The alert rule resources scope.
 * @property severity The alert rule severity.
 * @property state The alert rule state.
 * @property tags The resource tags.
 * @property throttling The alert rule throttling information.
 * @property type The resource type.
 */
public data class GetSmartDetectorAlertRuleResult(
    public val actionGroups: ActionGroupsInformationResponse,
    public val description: String? = null,
    public val detector: DetectorResponse,
    public val frequency: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val scope: List<String>,
    public val severity: String,
    public val state: String,
    public val tags: Map<String, String>? = null,
    public val throttling: ThrottlingInformationResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.GetSmartDetectorAlertRuleResult):
            GetSmartDetectorAlertRuleResult = GetSmartDetectorAlertRuleResult(
            actionGroups = javaType.actionGroups().let({ args0 ->
                com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ActionGroupsInformationResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            detector = javaType.detector().let({ args0 ->
                com.pulumi.azurenative.alertsmanagement.kotlin.outputs.DetectorResponse.Companion.toKotlin(args0)
            }),
            frequency = javaType.frequency(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            scope = javaType.scope().map({ args0 -> args0 }),
            severity = javaType.severity(),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            throttling = javaType.throttling().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.alertsmanagement.kotlin.outputs.ThrottlingInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
