@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Monthly recurrence object.
 * @property daysOfMonth Specifies the values for monthly recurrence pattern.
 * @property endTime End time for recurrence.
 * @property recurrenceType Specifies when the recurrence should be applied.
 * Expected value is 'Monthly'.
 * @property startTime Start time for recurrence.
 */
public data class MonthlyRecurrenceResponse(
    public val daysOfMonth: List<Int>,
    public val endTime: String? = null,
    public val recurrenceType: String,
    public val startTime: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.MonthlyRecurrenceResponse):
            MonthlyRecurrenceResponse = MonthlyRecurrenceResponse(
            daysOfMonth = javaType.daysOfMonth().map({ args0 -> args0 }),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            recurrenceType = javaType.recurrenceType(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
