@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.alertsmanagement.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Scheduling configuration for a given alert processing rule.
 * @property effectiveFrom Scheduling effective from time. Date-Time in ISO-8601 format without timezone suffix.
 * @property effectiveUntil Scheduling effective until time. Date-Time in ISO-8601 format without timezone suffix.
 * @property recurrences List of recurrences.
 * @property timeZone Scheduling time zone.
 */
public data class ScheduleResponse(
    public val effectiveFrom: String? = null,
    public val effectiveUntil: String? = null,
    public val recurrences: List<Any>? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.alertsmanagement.outputs.ScheduleResponse):
            ScheduleResponse = ScheduleResponse(
            effectiveFrom = javaType.effectiveFrom().map({ args0 -> args0 }).orElse(null),
            effectiveUntil = javaType.effectiveUntil().map({ args0 -> args0 }).orElse(null),
            recurrences = javaType.recurrences().map({ args0 -> args0 }),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
