@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin

import com.pulumi.azurenative.analysisservices.AnalysisservicesFunctions.getServerDetailsPlain
import com.pulumi.azurenative.analysisservices.AnalysisservicesFunctions.listServerGatewayStatusPlain
import com.pulumi.azurenative.analysisservices.kotlin.inputs.GetServerDetailsPlainArgs
import com.pulumi.azurenative.analysisservices.kotlin.inputs.GetServerDetailsPlainArgsBuilder
import com.pulumi.azurenative.analysisservices.kotlin.inputs.ListServerGatewayStatusPlainArgs
import com.pulumi.azurenative.analysisservices.kotlin.inputs.ListServerGatewayStatusPlainArgsBuilder
import com.pulumi.azurenative.analysisservices.kotlin.outputs.GetServerDetailsResult
import com.pulumi.azurenative.analysisservices.kotlin.outputs.ListServerGatewayStatusResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.analysisservices.kotlin.outputs.GetServerDetailsResult.Companion.toKotlin as getServerDetailsResultToKotlin
import com.pulumi.azurenative.analysisservices.kotlin.outputs.ListServerGatewayStatusResult.Companion.toKotlin as listServerGatewayStatusResultToKotlin

public object AnalysisservicesFunctions {
    /**
     * Gets details about the specified Analysis Services server.
     * Azure REST API version: 2017-08-01.
     * Other available API versions: 2017-08-01-beta.
     * @param argument null
     * @return Represents an instance of an Analysis Services resource.
     */
    public suspend fun getServerDetails(argument: GetServerDetailsPlainArgs): GetServerDetailsResult =
        getServerDetailsResultToKotlin(getServerDetailsPlain(argument.toJava()).await())

    /**
     * @see [getServerDetails].
     * @param resourceGroupName The name of the Azure Resource group of which a given Analysis Services server is part. This name must be at least 1 character in length, and no more than 90.
     * @param serverName The name of the Analysis Services server. It must be a minimum of 3 characters, and a maximum of 63.
     * @return Represents an instance of an Analysis Services resource.
     */
    public suspend fun getServerDetails(resourceGroupName: String, serverName: String):
        GetServerDetailsResult {
        val argument = GetServerDetailsPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerDetailsResultToKotlin(getServerDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;analysisservices&#46;kotlin&#46;inputs&#46;GetServerDetailsPlainArgs].
     * @return Represents an instance of an Analysis Services resource.
     */
    public suspend
    fun getServerDetails(argument: suspend GetServerDetailsPlainArgsBuilder.() -> Unit):
        GetServerDetailsResult {
        val builder = GetServerDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerDetailsResultToKotlin(getServerDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Return the gateway status of the specified Analysis Services server instance.
     * Azure REST API version: 2017-08-01.
     * Other available API versions: 2017-08-01-beta.
     * @param argument null
     * @return Status of gateway is live.
     */
    public suspend fun listServerGatewayStatus(argument: ListServerGatewayStatusPlainArgs):
        ListServerGatewayStatusResult =
        listServerGatewayStatusResultToKotlin(listServerGatewayStatusPlain(argument.toJava()).await())

    /**
     * @see [listServerGatewayStatus].
     * @param resourceGroupName The name of the Azure Resource group of which a given Analysis Services server is part. This name must be at least 1 character in length, and no more than 90.
     * @param serverName The name of the Analysis Services server.
     * @return Status of gateway is live.
     */
    public suspend fun listServerGatewayStatus(resourceGroupName: String, serverName: String):
        ListServerGatewayStatusResult {
        val argument = ListServerGatewayStatusPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return listServerGatewayStatusResultToKotlin(listServerGatewayStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [listServerGatewayStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;analysisservices&#46;kotlin&#46;inputs&#46;ListServerGatewayStatusPlainArgs].
     * @return Status of gateway is live.
     */
    public suspend
    fun listServerGatewayStatus(argument: suspend ListServerGatewayStatusPlainArgsBuilder.() -> Unit):
        ListServerGatewayStatusResult {
        val builder = ListServerGatewayStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listServerGatewayStatusResultToKotlin(listServerGatewayStatusPlain(builtArgument.toJava()).await())
    }
}
