@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin

import com.pulumi.azurenative.analysisservices.ServerDetailsArgs.builder
import com.pulumi.azurenative.analysisservices.kotlin.enums.ConnectionMode
import com.pulumi.azurenative.analysisservices.kotlin.inputs.GatewayDetailsArgs
import com.pulumi.azurenative.analysisservices.kotlin.inputs.GatewayDetailsArgsBuilder
import com.pulumi.azurenative.analysisservices.kotlin.inputs.IPv4FirewallSettingsArgs
import com.pulumi.azurenative.analysisservices.kotlin.inputs.IPv4FirewallSettingsArgsBuilder
import com.pulumi.azurenative.analysisservices.kotlin.inputs.ResourceSkuArgs
import com.pulumi.azurenative.analysisservices.kotlin.inputs.ResourceSkuArgsBuilder
import com.pulumi.azurenative.analysisservices.kotlin.inputs.ServerAdministratorsArgs
import com.pulumi.azurenative.analysisservices.kotlin.inputs.ServerAdministratorsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an instance of an Analysis Services resource.
 * Azure REST API version: 2017-08-01. Prior API version in Azure Native 1.x: 2017-08-01.
 * Other available API versions: 2017-08-01-beta.
 * ## Example Usage
 * ### Create a server.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverDetails = new AzureNative.AnalysisServices.ServerDetails("serverDetails", new()
 *     {
 *         AsAdministrators = new AzureNative.AnalysisServices.Inputs.ServerAdministratorsArgs
 *         {
 *             Members = new[]
 *             {
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com",
 *             },
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         ServerName = "azsdktest",
 *         Sku = new AzureNative.AnalysisServices.Inputs.ResourceSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "S1",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "testKey", "testValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/analysisservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := analysisservices.NewServerDetails(ctx, "serverDetails", &analysisservices.ServerDetailsArgs{
 * 			AsAdministrators: &analysisservices.ServerAdministratorsArgs{
 * 				Members: pulumi.StringArray{
 * 					pulumi.String("azsdktest@microsoft.com"),
 * 					pulumi.String("azsdktest2@microsoft.com"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			ServerName:        pulumi.String("azsdktest"),
 * 			Sku: &analysisservices.ResourceSkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("S1"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"testKey": pulumi.String("testValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.analysisservices.ServerDetails;
 * import com.pulumi.azurenative.analysisservices.ServerDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverDetails = new ServerDetails("serverDetails", ServerDetailsArgs.builder()
 *             .asAdministrators(Map.of("members",
 *                 "azsdktest@microsoft.com",
 *                 "azsdktest2@microsoft.com"))
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .serverName("azsdktest")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "S1"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("testKey", "testValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:analysisservices:ServerDetails azsdktest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}
 * ```
 * @property asAdministrators A collection of AS server administrators
 * @property backupBlobContainerUri The SAS container URI to the backup container.
 * @property gatewayDetails The gateway details configured for the AS server.
 * @property ipV4FirewallSettings The firewall settings for the AS server.
 * @property location Location of the Analysis Services resource.
 * @property managedMode The managed mode of the server (0 = not managed, 1 = managed).
 * @property querypoolConnectionMode How the read-write server's participation in the query pool is controlled.<br/>It can have the following values: <ul><li>readOnly - indicates that the read-write server is intended not to participate in query operations</li><li>all - indicates that the read-write server can participate in query operations</li></ul>Specifying readOnly when capacity is 1 results in error.
 * @property resourceGroupName The name of the Azure Resource group of which a given Analysis Services server is part. This name must be at least 1 character in length, and no more than 90.
 * @property serverMonitorMode The server monitor mode for AS server
 * @property serverName The name of the Analysis Services server. It must be a minimum of 3 characters, and a maximum of 63.
 * @property sku The SKU of the Analysis Services resource.
 * @property tags Key-value pairs of additional resource provisioning properties.
 */
public data class ServerDetailsArgs(
    public val asAdministrators: Output<ServerAdministratorsArgs>? = null,
    public val backupBlobContainerUri: Output<String>? = null,
    public val gatewayDetails: Output<GatewayDetailsArgs>? = null,
    public val ipV4FirewallSettings: Output<IPv4FirewallSettingsArgs>? = null,
    public val location: Output<String>? = null,
    public val managedMode: Output<Int>? = null,
    public val querypoolConnectionMode: Output<ConnectionMode>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverMonitorMode: Output<Int>? = null,
    public val serverName: Output<String>? = null,
    public val sku: Output<ResourceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.analysisservices.ServerDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.analysisservices.ServerDetailsArgs =
        com.pulumi.azurenative.analysisservices.ServerDetailsArgs.builder()
            .asAdministrators(asAdministrators?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupBlobContainerUri(backupBlobContainerUri?.applyValue({ args0 -> args0 }))
            .gatewayDetails(gatewayDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipV4FirewallSettings(
                ipV4FirewallSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .managedMode(managedMode?.applyValue({ args0 -> args0 }))
            .querypoolConnectionMode(
                querypoolConnectionMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverMonitorMode(serverMonitorMode?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServerDetailsArgs].
 */
@PulumiTagMarker
public class ServerDetailsArgsBuilder internal constructor() {
    private var asAdministrators: Output<ServerAdministratorsArgs>? = null

    private var backupBlobContainerUri: Output<String>? = null

    private var gatewayDetails: Output<GatewayDetailsArgs>? = null

    private var ipV4FirewallSettings: Output<IPv4FirewallSettingsArgs>? = null

    private var location: Output<String>? = null

    private var managedMode: Output<Int>? = null

    private var querypoolConnectionMode: Output<ConnectionMode>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverMonitorMode: Output<Int>? = null

    private var serverName: Output<String>? = null

    private var sku: Output<ResourceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A collection of AS server administrators
     */
    @JvmName("gewoenfytcvtdbqy")
    public suspend fun asAdministrators(`value`: Output<ServerAdministratorsArgs>) {
        this.asAdministrators = value
    }

    /**
     * @param value The SAS container URI to the backup container.
     */
    @JvmName("ntlcvjcamtqdeugr")
    public suspend fun backupBlobContainerUri(`value`: Output<String>) {
        this.backupBlobContainerUri = value
    }

    /**
     * @param value The gateway details configured for the AS server.
     */
    @JvmName("oobitoswycqfeuno")
    public suspend fun gatewayDetails(`value`: Output<GatewayDetailsArgs>) {
        this.gatewayDetails = value
    }

    /**
     * @param value The firewall settings for the AS server.
     */
    @JvmName("vvqlplwyvxmxvqvn")
    public suspend fun ipV4FirewallSettings(`value`: Output<IPv4FirewallSettingsArgs>) {
        this.ipV4FirewallSettings = value
    }

    /**
     * @param value Location of the Analysis Services resource.
     */
    @JvmName("ltnsytehjqdjbbxm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The managed mode of the server (0 = not managed, 1 = managed).
     */
    @JvmName("uxksgkmduaandmej")
    public suspend fun managedMode(`value`: Output<Int>) {
        this.managedMode = value
    }

    /**
     * @param value How the read-write server's participation in the query pool is controlled.<br/>It can have the following values: <ul><li>readOnly - indicates that the read-write server is intended not to participate in query operations</li><li>all - indicates that the read-write server can participate in query operations</li></ul>Specifying readOnly when capacity is 1 results in error.
     */
    @JvmName("hctgauhywuyigulm")
    public suspend fun querypoolConnectionMode(`value`: Output<ConnectionMode>) {
        this.querypoolConnectionMode = value
    }

    /**
     * @param value The name of the Azure Resource group of which a given Analysis Services server is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("qebmaripssyfwjtb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The server monitor mode for AS server
     */
    @JvmName("fanihshldwfrwxtp")
    public suspend fun serverMonitorMode(`value`: Output<Int>) {
        this.serverMonitorMode = value
    }

    /**
     * @param value The name of the Analysis Services server. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("putiqhrnpwvigeqn")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The SKU of the Analysis Services resource.
     */
    @JvmName("yrrntgpwcvimcvwq")
    public suspend fun sku(`value`: Output<ResourceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("vdkvjmywmqndylua")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A collection of AS server administrators
     */
    @JvmName("jplyjlwiswvcojhl")
    public suspend fun asAdministrators(`value`: ServerAdministratorsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asAdministrators = mapped
    }

    /**
     * @param argument A collection of AS server administrators
     */
    @JvmName("ikcosoqklchhtiug")
    public suspend
    fun asAdministrators(argument: suspend ServerAdministratorsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerAdministratorsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.asAdministrators = mapped
    }

    /**
     * @param value The SAS container URI to the backup container.
     */
    @JvmName("junutvhpmpjiuhys")
    public suspend fun backupBlobContainerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupBlobContainerUri = mapped
    }

    /**
     * @param value The gateway details configured for the AS server.
     */
    @JvmName("vaayqdgrphxrnrme")
    public suspend fun gatewayDetails(`value`: GatewayDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayDetails = mapped
    }

    /**
     * @param argument The gateway details configured for the AS server.
     */
    @JvmName("mxygwfhkwddjdhrt")
    public suspend fun gatewayDetails(argument: suspend GatewayDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gatewayDetails = mapped
    }

    /**
     * @param value The firewall settings for the AS server.
     */
    @JvmName("ffjwmyewqhffsobv")
    public suspend fun ipV4FirewallSettings(`value`: IPv4FirewallSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipV4FirewallSettings = mapped
    }

    /**
     * @param argument The firewall settings for the AS server.
     */
    @JvmName("cuaglxwdifexrhqd")
    public suspend
    fun ipV4FirewallSettings(argument: suspend IPv4FirewallSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = IPv4FirewallSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipV4FirewallSettings = mapped
    }

    /**
     * @param value Location of the Analysis Services resource.
     */
    @JvmName("xnronxbvdfryiagw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The managed mode of the server (0 = not managed, 1 = managed).
     */
    @JvmName("rlfbdjkarapeotge")
    public suspend fun managedMode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedMode = mapped
    }

    /**
     * @param value How the read-write server's participation in the query pool is controlled.<br/>It can have the following values: <ul><li>readOnly - indicates that the read-write server is intended not to participate in query operations</li><li>all - indicates that the read-write server can participate in query operations</li></ul>Specifying readOnly when capacity is 1 results in error.
     */
    @JvmName("bpmockcdukvhpqsf")
    public suspend fun querypoolConnectionMode(`value`: ConnectionMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.querypoolConnectionMode = mapped
    }

    /**
     * @param value The name of the Azure Resource group of which a given Analysis Services server is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("cwedvnfutkqulkbr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The server monitor mode for AS server
     */
    @JvmName("pwaemjsvgratllwq")
    public suspend fun serverMonitorMode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverMonitorMode = mapped
    }

    /**
     * @param value The name of the Analysis Services server. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("dxtvilarlggnwuvf")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The SKU of the Analysis Services resource.
     */
    @JvmName("sxjcpyedpljixioj")
    public suspend fun sku(`value`: ResourceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the Analysis Services resource.
     */
    @JvmName("myquipisoaputylk")
    public suspend fun sku(argument: suspend ResourceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("sjmknrmlrfrnocmh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value pairs of additional resource provisioning properties.
     */
    @JvmName("whsfirjxrpsephxw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServerDetailsArgs = ServerDetailsArgs(
        asAdministrators = asAdministrators,
        backupBlobContainerUri = backupBlobContainerUri,
        gatewayDetails = gatewayDetails,
        ipV4FirewallSettings = ipV4FirewallSettings,
        location = location,
        managedMode = managedMode,
        querypoolConnectionMode = querypoolConnectionMode,
        resourceGroupName = resourceGroupName,
        serverMonitorMode = serverMonitorMode,
        serverName = serverName,
        sku = sku,
        tags = tags,
    )
}
