@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * How the read-write server's participation in the query pool is controlled.<br/>It can have the following values: <ul><li>readOnly - indicates that the read-write server is intended not to participate in query operations</li><li>all - indicates that the read-write server can participate in query operations</li></ul>Specifying readOnly when capacity is 1 results in error.
 */
public enum class ConnectionMode(
    public val javaValue: com.pulumi.azurenative.analysisservices.enums.ConnectionMode,
) : ConvertibleToJava<com.pulumi.azurenative.analysisservices.enums.ConnectionMode> {
    All(com.pulumi.azurenative.analysisservices.enums.ConnectionMode.All),
    ReadOnly(com.pulumi.azurenative.analysisservices.enums.ConnectionMode.ReadOnly),
    ;

    override fun toJava(): com.pulumi.azurenative.analysisservices.enums.ConnectionMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.analysisservices.enums.ConnectionMode):
            ConnectionMode = ConnectionMode.values().first { it.javaValue == javaType }
    }
}
