@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.analysisservices.kotlin.inputs

import com.pulumi.azurenative.analysisservices.inputs.IPv4FirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The detail of firewall rule.
 * @property firewallRuleName The rule name.
 * @property rangeEnd The end range of IPv4.
 * @property rangeStart The start range of IPv4.
 */
public data class IPv4FirewallRuleArgs(
    public val firewallRuleName: Output<String>? = null,
    public val rangeEnd: Output<String>? = null,
    public val rangeStart: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.analysisservices.inputs.IPv4FirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.analysisservices.inputs.IPv4FirewallRuleArgs =
        com.pulumi.azurenative.analysisservices.inputs.IPv4FirewallRuleArgs.builder()
            .firewallRuleName(firewallRuleName?.applyValue({ args0 -> args0 }))
            .rangeEnd(rangeEnd?.applyValue({ args0 -> args0 }))
            .rangeStart(rangeStart?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPv4FirewallRuleArgs].
 */
@PulumiTagMarker
public class IPv4FirewallRuleArgsBuilder internal constructor() {
    private var firewallRuleName: Output<String>? = null

    private var rangeEnd: Output<String>? = null

    private var rangeStart: Output<String>? = null

    /**
     * @param value The rule name.
     */
    @JvmName("hjilstlnpohycdoj")
    public suspend fun firewallRuleName(`value`: Output<String>) {
        this.firewallRuleName = value
    }

    /**
     * @param value The end range of IPv4.
     */
    @JvmName("uyuycmobhbudpfpe")
    public suspend fun rangeEnd(`value`: Output<String>) {
        this.rangeEnd = value
    }

    /**
     * @param value The start range of IPv4.
     */
    @JvmName("cdcbvjidbqgwoeij")
    public suspend fun rangeStart(`value`: Output<String>) {
        this.rangeStart = value
    }

    /**
     * @param value The rule name.
     */
    @JvmName("acgcxbgxoaibntma")
    public suspend fun firewallRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleName = mapped
    }

    /**
     * @param value The end range of IPv4.
     */
    @JvmName("wevuoisqfsvxbdab")
    public suspend fun rangeEnd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rangeEnd = mapped
    }

    /**
     * @param value The start range of IPv4.
     */
    @JvmName("cldkoseohoapwnpy")
    public suspend fun rangeStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rangeStart = mapped
    }

    internal fun build(): IPv4FirewallRuleArgs = IPv4FirewallRuleArgs(
        firewallRuleName = firewallRuleName,
        rangeEnd = rangeEnd,
        rangeStart = rangeStart,
    )
}
