@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.kotlin.outputs.ApiDefinitionPropertiesResponseSpecification
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.apicenter.kotlin.outputs.ApiDefinitionPropertiesResponseSpecification.Companion.toKotlin as apiDefinitionPropertiesResponseSpecificationToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ApiDefinition].
 */
@PulumiTagMarker
public class ApiDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiDefinitionArgs = ApiDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiDefinitionArgsBuilder.() -> Unit) {
        val builder = ApiDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiDefinition {
        val builtJavaResource = com.pulumi.azurenative.apicenter.ApiDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiDefinition(builtJavaResource)
    }
}

/**
 * API definition entity.
 * Azure REST API version: 2024-03-01.
 * ## Example Usage
 * ### ApiDefinitions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiDefinition = new AzureNative.ApiCenter.ApiDefinition("apiDefinition", new()
 *     {
 *         ApiName = "openapi",
 *         DefinitionName = "openapi",
 *         Description = "Default spec",
 *         ResourceGroupName = "contoso-resources",
 *         ServiceName = "contoso",
 *         Title = "OpenAPI",
 *         VersionName = "2023-01-01",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewApiDefinition(ctx, "apiDefinition", &apicenter.ApiDefinitionArgs{
 * 			ApiName:           pulumi.String("openapi"),
 * 			DefinitionName:    pulumi.String("openapi"),
 * 			Description:       pulumi.String("Default spec"),
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			ServiceName:       pulumi.String("contoso"),
 * 			Title:             pulumi.String("OpenAPI"),
 * 			VersionName:       pulumi.String("2023-01-01"),
 * 			WorkspaceName:     pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.ApiDefinition;
 * import com.pulumi.azurenative.apicenter.ApiDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiDefinition = new ApiDefinition("apiDefinition", ApiDefinitionArgs.builder()
 *             .apiName("openapi")
 *             .definitionName("openapi")
 *             .description("Default spec")
 *             .resourceGroupName("contoso-resources")
 *             .serviceName("contoso")
 *             .title("OpenAPI")
 *             .versionName("2023-01-01")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:ApiDefinition openapi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/apis/{apiName}/versions/{versionName}/definitions/{definitionName}
 * ```
 */
public class ApiDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.apicenter.ApiDefinition,
) : KotlinCustomResource(javaResource, ApiDefinitionMapper) {
    /**
     * API definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * API specification details.
     */
    public val specification: Output<ApiDefinitionPropertiesResponseSpecification>
        get() = javaResource.specification().applyValue({ args0 ->
            args0.let({ args0 ->
                apiDefinitionPropertiesResponseSpecificationToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * API definition title.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApiDefinitionMapper : ResourceMapper<ApiDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apicenter.ApiDefinition::class == javaResource::class

    override fun map(javaResource: Resource): ApiDefinition = ApiDefinition(
        javaResource as
            com.pulumi.azurenative.apicenter.ApiDefinition,
    )
}

/**
 * @see [ApiDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiDefinition].
 */
public suspend fun apiDefinition(
    name: String,
    block: suspend ApiDefinitionResourceBuilder.() -> Unit,
): ApiDefinition {
    val builder = ApiDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiDefinition(name: String): ApiDefinition {
    val builder = ApiDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
