@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin

import com.pulumi.azurenative.apicenter.kotlin.outputs.EnvironmentServerResponse
import com.pulumi.azurenative.apicenter.kotlin.outputs.OnboardingResponse
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.apicenter.kotlin.outputs.EnvironmentServerResponse.Companion.toKotlin as environmentServerResponseToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.OnboardingResponse.Companion.toKotlin as onboardingResponseToKotlin
import com.pulumi.azurenative.apicenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Environment].
 */
@PulumiTagMarker
public class EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentArgs = EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentArgsBuilder.() -> Unit) {
        val builder = EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Environment {
        val builtJavaResource = com.pulumi.azurenative.apicenter.Environment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Environment(builtJavaResource)
    }
}

/**
 * Environment entity.
 * Azure REST API version: 2024-03-01.
 * ## Example Usage
 * ### Environments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environment = new AzureNative.ApiCenter.Environment("environment", new()
 *     {
 *         Description = "The primary Azure API Management service for the European division of Contoso.",
 *         EnvironmentName = "public",
 *         Kind = "production",
 *         Onboarding = new AzureNative.ApiCenter.Inputs.OnboardingArgs
 *         {
 *             DeveloperPortalUri = new[]
 *             {
 *                 "https://developer.contoso.com",
 *             },
 *             Instructions = "Sign in or sign up in the specified developer portal to request API access. You must complete the internal privacy training for your account to be approved.",
 *         },
 *         ResourceGroupName = "contoso-resources",
 *         Server = new AzureNative.ApiCenter.Inputs.EnvironmentServerArgs
 *         {
 *             ManagementPortalUri = new[]
 *             {
 *                 "https://management.azure.com/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ApiManagement/service/contoso",
 *             },
 *             Type = "Azure API Management",
 *         },
 *         ServiceName = "contoso",
 *         Title = "Contoso Europe Azure API Management",
 *         WorkspaceName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apicenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apicenter.NewEnvironment(ctx, "environment", &apicenter.EnvironmentArgs{
 * 			Description:     pulumi.String("The primary Azure API Management service for the European division of Contoso."),
 * 			EnvironmentName: pulumi.String("public"),
 * 			Kind:            pulumi.String("production"),
 * 			Onboarding: &apicenter.OnboardingArgs{
 * 				DeveloperPortalUri: pulumi.StringArray{
 * 					pulumi.String("https://developer.contoso.com"),
 * 				},
 * 				Instructions: pulumi.String("Sign in or sign up in the specified developer portal to request API access. You must complete the internal privacy training for your account to be approved."),
 * 			},
 * 			ResourceGroupName: pulumi.String("contoso-resources"),
 * 			Server: &apicenter.EnvironmentServerArgs{
 * 				ManagementPortalUri: pulumi.StringArray{
 * 					pulumi.String("https://management.azure.com/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ApiManagement/service/contoso"),
 * 				},
 * 				Type: pulumi.String("Azure API Management"),
 * 			},
 * 			ServiceName:   pulumi.String("contoso"),
 * 			Title:         pulumi.String("Contoso Europe Azure API Management"),
 * 			WorkspaceName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apicenter.Environment;
 * import com.pulumi.azurenative.apicenter.EnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environment = new Environment("environment", EnvironmentArgs.builder()
 *             .description("The primary Azure API Management service for the European division of Contoso.")
 *             .environmentName("public")
 *             .kind("production")
 *             .onboarding(Map.ofEntries(
 *                 Map.entry("developerPortalUri", "https://developer.contoso.com"),
 *                 Map.entry("instructions", "Sign in or sign up in the specified developer portal to request API access. You must complete the internal privacy training for your account to be approved.")
 *             ))
 *             .resourceGroupName("contoso-resources")
 *             .server(Map.ofEntries(
 *                 Map.entry("managementPortalUri", "https://management.azure.com/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contoso-resources/providers/Microsoft.ApiManagement/service/contoso"),
 *                 Map.entry("type", "Azure API Management")
 *             ))
 *             .serviceName("contoso")
 *             .title("Contoso Europe Azure API Management")
 *             .workspaceName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apicenter:Environment public /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiCenter/services/{serviceName}/workspaces/{workspaceName}/environments/{environmentName}
 * ```
 */
public class Environment internal constructor(
    override val javaResource: com.pulumi.azurenative.apicenter.Environment,
) : KotlinCustomResource(javaResource, EnvironmentMapper) {
    /**
     * The custom metadata defined for API catalog entities.
     */
    public val customProperties: Output<Any>?
        get() = javaResource.customProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Environment kind.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val onboarding: Output<OnboardingResponse>?
        get() = javaResource.onboarding().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    onboardingResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Server information of the environment.
     */
    public val server: Output<EnvironmentServerResponse>?
        get() = javaResource.server().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    environmentServerResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Environment title.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnvironmentMapper : ResourceMapper<Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apicenter.Environment::class == javaResource::class

    override fun map(javaResource: Resource): Environment = Environment(
        javaResource as
            com.pulumi.azurenative.apicenter.Environment,
    )
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Environment].
 */
public suspend fun environment(name: String, block: suspend EnvironmentResourceBuilder.() -> Unit):
    Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environment(name: String): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
