@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.GetApiVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiName The name of the API.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 * @property versionName The name of the API version.
 * @property workspaceName The name of the workspace.
 */
public data class GetApiVersionPlainArgs(
    public val apiName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val versionName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.GetApiVersionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.GetApiVersionPlainArgs =
        com.pulumi.azurenative.apicenter.inputs.GetApiVersionPlainArgs.builder()
            .apiName(apiName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .versionName(versionName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApiVersionPlainArgs].
 */
@PulumiTagMarker
public class GetApiVersionPlainArgsBuilder internal constructor() {
    private var apiName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var versionName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the API.
     */
    @JvmName("epxhpdfjlniiqmug")
    public suspend fun apiName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yrjnhsivkwfvhmgs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("qahgeoqbsuuyrest")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the API version.
     */
    @JvmName("ltkldjbaerhgbkff")
    public suspend fun versionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.versionName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("hjjgdbhqwpmwtgpb")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetApiVersionPlainArgs = GetApiVersionPlainArgs(
        apiName = apiName ?: throw PulumiNullFieldException("apiName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        versionName = versionName ?: throw PulumiNullFieldException("versionName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
