@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apicenter.kotlin.inputs

import com.pulumi.azurenative.apicenter.inputs.GetDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiName The name of the API.
 * @property deploymentName The name of the API deployment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of Azure API Center service.
 * @property workspaceName The name of the workspace.
 */
public data class GetDeploymentPlainArgs(
    public val apiName: String,
    public val deploymentName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apicenter.inputs.GetDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apicenter.inputs.GetDeploymentPlainArgs =
        com.pulumi.azurenative.apicenter.inputs.GetDeploymentPlainArgs.builder()
            .apiName(apiName.let({ args0 -> args0 }))
            .deploymentName(deploymentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentPlainArgsBuilder internal constructor() {
    private var apiName: String? = null

    private var deploymentName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the API.
     */
    @JvmName("jxopkvieeosqfrtt")
    public suspend fun apiName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.apiName = mapped
    }

    /**
     * @param value The name of the API deployment.
     */
    @JvmName("mvekefwtycxffhvn")
    public suspend fun deploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wejmvdralytsjxno")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of Azure API Center service.
     */
    @JvmName("qemvgridgvuydsql")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("iuppkgfdljwtsbit")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetDeploymentPlainArgs = GetDeploymentPlainArgs(
        apiName = apiName ?: throw PulumiNullFieldException("apiName"),
        deploymentName = deploymentName ?: throw PulumiNullFieldException("deploymentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
