@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiIssueAttachment].
 */
@PulumiTagMarker
public class ApiIssueAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiIssueAttachmentArgs = ApiIssueAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiIssueAttachmentArgsBuilder.() -> Unit) {
        val builder = ApiIssueAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiIssueAttachment {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ApiIssueAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApiIssueAttachment(builtJavaResource)
    }
}

/**
 * Issue Attachment Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiIssueAttachment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiIssueAttachment = new AzureNative.ApiManagement.ApiIssueAttachment("apiIssueAttachment", new()
 *     {
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         AttachmentId = "57d2ef278aa04f0888cba3f3",
 *         Content = "IEJhc2U2NA==",
 *         ContentFormat = "image/jpeg",
 *         IssueId = "57d2ef278aa04f0ad01d6cdc",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Title = "Issue attachment.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiIssueAttachment(ctx, "apiIssueAttachment", &apimanagement.ApiIssueAttachmentArgs{
 * 			ApiId:             pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			AttachmentId:      pulumi.String("57d2ef278aa04f0888cba3f3"),
 * 			Content:           pulumi.String("IEJhc2U2NA=="),
 * 			ContentFormat:     pulumi.String("image/jpeg"),
 * 			IssueId:           pulumi.String("57d2ef278aa04f0ad01d6cdc"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Title:             pulumi.String("Issue attachment."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiIssueAttachment;
 * import com.pulumi.azurenative.apimanagement.ApiIssueAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiIssueAttachment = new ApiIssueAttachment("apiIssueAttachment", ApiIssueAttachmentArgs.builder()
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .attachmentId("57d2ef278aa04f0888cba3f3")
 *             .content("IEJhc2U2NA==")
 *             .contentFormat("image/jpeg")
 *             .issueId("57d2ef278aa04f0ad01d6cdc")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .title("Issue attachment.")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiIssueAttachment 57d2ef278aa04f0888cba3f3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/attachments/{attachmentId}
 * ```
 */
public class ApiIssueAttachment internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiIssueAttachment,
) : KotlinCustomResource(javaResource, ApiIssueAttachmentMapper) {
    /**
     * An HTTP link or Base64-encoded binary data.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * Either 'link' if content is provided via an HTTP link or the MIME type of the Base64-encoded binary data provided in the 'content' property.
     */
    public val contentFormat: Output<String>
        get() = javaResource.contentFormat().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Filename by which the binary data will be saved.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApiIssueAttachmentMapper : ResourceMapper<ApiIssueAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiIssueAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ApiIssueAttachment = ApiIssueAttachment(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiIssueAttachment,
    )
}

/**
 * @see [ApiIssueAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiIssueAttachment].
 */
public suspend fun apiIssueAttachment(
    name: String,
    block: suspend ApiIssueAttachmentResourceBuilder.() -> Unit,
): ApiIssueAttachment {
    val builder = ApiIssueAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiIssueAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiIssueAttachment(name: String): ApiIssueAttachment {
    val builder = ApiIssueAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
