@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiIssueCommentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Issue Comment Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiIssueComment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiIssueComment = new AzureNative.ApiManagement.ApiIssueComment("apiIssueComment", new()
 *     {
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         CommentId = "599e29ab193c3c0bd0b3e2fb",
 *         CreatedDate = "2018-02-01T22:21:20.467Z",
 *         IssueId = "57d2ef278aa04f0ad01d6cdc",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Text = "Issue comment.",
 *         UserId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiIssueComment(ctx, "apiIssueComment", &apimanagement.ApiIssueCommentArgs{
 * 			ApiId:             pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			CommentId:         pulumi.String("599e29ab193c3c0bd0b3e2fb"),
 * 			CreatedDate:       pulumi.String("2018-02-01T22:21:20.467Z"),
 * 			IssueId:           pulumi.String("57d2ef278aa04f0ad01d6cdc"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Text:              pulumi.String("Issue comment."),
 * 			UserId:            pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiIssueComment;
 * import com.pulumi.azurenative.apimanagement.ApiIssueCommentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiIssueComment = new ApiIssueComment("apiIssueComment", ApiIssueCommentArgs.builder()
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .commentId("599e29ab193c3c0bd0b3e2fb")
 *             .createdDate("2018-02-01T22:21:20.467Z")
 *             .issueId("57d2ef278aa04f0ad01d6cdc")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .text("Issue comment.")
 *             .userId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiIssueComment 599e29ab193c3c0bd0b3e2fb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/issues/{issueId}/comments/{commentId}
 * ```
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property commentId Comment identifier within an Issue. Must be unique in the current Issue.
 * @property createdDate Date and time when the comment was created.
 * @property issueId Issue identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property text Comment text.
 * @property userId A resource identifier for the user who left the comment.
 */
public data class ApiIssueCommentArgs(
    public val apiId: Output<String>? = null,
    public val commentId: Output<String>? = null,
    public val createdDate: Output<String>? = null,
    public val issueId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val text: Output<String>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiIssueCommentArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiIssueCommentArgs =
        com.pulumi.azurenative.apimanagement.ApiIssueCommentArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .commentId(commentId?.applyValue({ args0 -> args0 }))
            .createdDate(createdDate?.applyValue({ args0 -> args0 }))
            .issueId(issueId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .text(text?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiIssueCommentArgs].
 */
@PulumiTagMarker
public class ApiIssueCommentArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var commentId: Output<String>? = null

    private var createdDate: Output<String>? = null

    private var issueId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var text: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("hujsgnldwcaunvsd")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Comment identifier within an Issue. Must be unique in the current Issue.
     */
    @JvmName("iwpnxnmxrupxeuhs")
    public suspend fun commentId(`value`: Output<String>) {
        this.commentId = value
    }

    /**
     * @param value Date and time when the comment was created.
     */
    @JvmName("rmgfynlwwbwhyhxj")
    public suspend fun createdDate(`value`: Output<String>) {
        this.createdDate = value
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jqoxjqgxrodfabmw")
    public suspend fun issueId(`value`: Output<String>) {
        this.issueId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kpcuabehkcsquddv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("frjspukpoyrryydx")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Comment text.
     */
    @JvmName("kmvshnsimefemibn")
    public suspend fun text(`value`: Output<String>) {
        this.text = value
    }

    /**
     * @param value A resource identifier for the user who left the comment.
     */
    @JvmName("hqcajrovdkqkldii")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jtoxsdhgkuopkooy")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Comment identifier within an Issue. Must be unique in the current Issue.
     */
    @JvmName("nhgpeinqcyxpqsyk")
    public suspend fun commentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commentId = mapped
    }

    /**
     * @param value Date and time when the comment was created.
     */
    @JvmName("xtiolrqlqjipnkhg")
    public suspend fun createdDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdDate = mapped
    }

    /**
     * @param value Issue identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("vukwvtatwcxlhqsp")
    public suspend fun issueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pphpqveudirauedp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("avwkhswjsxacfdqo")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Comment text.
     */
    @JvmName("irsiiycgokhixiba")
    public suspend fun text(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.text = mapped
    }

    /**
     * @param value A resource identifier for the user who left the comment.
     */
    @JvmName("jlettvphvkjriwmi")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): ApiIssueCommentArgs = ApiIssueCommentArgs(
        apiId = apiId,
        commentId = commentId,
        createdDate = createdDate,
        issueId = issueId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        text = text,
        userId = userId,
    )
}
