@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiOperationArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ParameterContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ParameterContractArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.RequestContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.RequestContractArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ResponseContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ResponseContractArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API Operation details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiOperation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiOperation = new AzureNative.ApiManagement.ApiOperation("apiOperation", new()
 *     {
 *         ApiId = "PetStoreTemplate2",
 *         Description = "This can only be done by the logged in user.",
 *         DisplayName = "createUser2",
 *         Method = "POST",
 *         OperationId = "newoperations",
 *         Request = new AzureNative.ApiManagement.Inputs.RequestContractArgs
 *         {
 *             Description = "Created user object",
 *             Headers = new() { },
 *             QueryParameters = new() { },
 *             Representations = new[]
 *             {
 *                 new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                 {
 *                     ContentType = "application/json",
 *                     SchemaId = "592f6c1d0af5840ca8897f0c",
 *                     TypeName = "User",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Responses = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.ResponseContractArgs
 *             {
 *                 Description = "successful operation",
 *                 Headers = new[] {},
 *                 Representations = new[]
 *                 {
 *                     new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                     {
 *                         ContentType = "application/xml",
 *                     },
 *                     new AzureNative.ApiManagement.Inputs.RepresentationContractArgs
 *                     {
 *                         ContentType = "application/json",
 *                     },
 *                 },
 *                 StatusCode = 200,
 *             },
 *         },
 *         ServiceName = "apimService1",
 *         TemplateParameters = new[] {},
 *         UrlTemplate = "/user1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiOperation(ctx, "apiOperation", &apimanagement.ApiOperationArgs{
 * 			ApiId:       pulumi.String("PetStoreTemplate2"),
 * 			Description: pulumi.String("This can only be done by the logged in user."),
 * 			DisplayName: pulumi.String("createUser2"),
 * 			Method:      pulumi.String("POST"),
 * 			OperationId: pulumi.String("newoperations"),
 * 			Request: apimanagement.RequestContractResponse{
 * 				Description:     pulumi.String("Created user object"),
 * 				Headers:         apimanagement.ParameterContractArray{},
 * 				QueryParameters: apimanagement.ParameterContractArray{},
 * 				Representations: apimanagement.RepresentationContractArray{
 * 					&apimanagement.RepresentationContractArgs{
 * 						ContentType: pulumi.String("application/json"),
 * 						SchemaId:    pulumi.String("592f6c1d0af5840ca8897f0c"),
 * 						TypeName:    pulumi.String("User"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Responses: []apimanagement.ResponseContractArgs{
 * 				{
 * 					Description: pulumi.String("successful operation"),
 * 					Headers:     apimanagement.ParameterContractArray{},
 * 					Representations: apimanagement.RepresentationContractArray{
 * 						{
 * 							ContentType: pulumi.String("application/xml"),
 * 						},
 * 						{
 * 							ContentType: pulumi.String("application/json"),
 * 						},
 * 					},
 * 					StatusCode: pulumi.Int(200),
 * 				},
 * 			},
 * 			ServiceName:        pulumi.String("apimService1"),
 * 			TemplateParameters: apimanagement.ParameterContractArray{},
 * 			UrlTemplate:        pulumi.String("/user1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiOperation;
 * import com.pulumi.azurenative.apimanagement.ApiOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiOperation = new ApiOperation("apiOperation", ApiOperationArgs.builder()
 *             .apiId("PetStoreTemplate2")
 *             .description("This can only be done by the logged in user.")
 *             .displayName("createUser2")
 *             .method("POST")
 *             .operationId("newoperations")
 *             .request(Map.ofEntries(
 *                 Map.entry("description", "Created user object"),
 *                 Map.entry("headers", ),
 *                 Map.entry("queryParameters", ),
 *                 Map.entry("representations", Map.ofEntries(
 *                     Map.entry("contentType", "application/json"),
 *                     Map.entry("schemaId", "592f6c1d0af5840ca8897f0c"),
 *                     Map.entry("typeName", "User")
 *                 ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .responses(Map.ofEntries(
 *                 Map.entry("description", "successful operation"),
 *                 Map.entry("headers", ),
 *                 Map.entry("representations",
 *                     Map.of("contentType", "application/xml"),
 *                     Map.of("contentType", "application/json")),
 *                 Map.entry("statusCode", 200)
 *             ))
 *             .serviceName("apimService1")
 *             .templateParameters()
 *             .urlTemplate("/user1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiOperation newoperations /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/operations/{operationId}
 * ```
 * @property apiId API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
 * @property description Description of the operation. May include HTML formatting tags.
 * @property displayName Operation Name.
 * @property method A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
 * @property operationId Operation identifier within an API. Must be unique in the current API Management service instance.
 * @property policies Operation Policies
 * @property request An entity containing request details.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property responses Array of Operation responses.
 * @property serviceName The name of the API Management service.
 * @property templateParameters Collection of URL template parameters.
 * @property urlTemplate Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
 */
public data class ApiOperationArgs(
    public val apiId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val method: Output<String>? = null,
    public val operationId: Output<String>? = null,
    public val policies: Output<String>? = null,
    public val request: Output<RequestContractArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val responses: Output<List<ResponseContractArgs>>? = null,
    public val serviceName: Output<String>? = null,
    public val templateParameters: Output<List<ParameterContractArgs>>? = null,
    public val urlTemplate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiOperationArgs =
        com.pulumi.azurenative.apimanagement.ApiOperationArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .method(method?.applyValue({ args0 -> args0 }))
            .operationId(operationId?.applyValue({ args0 -> args0 }))
            .policies(policies?.applyValue({ args0 -> args0 }))
            .request(request?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .responses(
                responses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .templateParameters(
                templateParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .urlTemplate(urlTemplate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiOperationArgs].
 */
@PulumiTagMarker
public class ApiOperationArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var method: Output<String>? = null

    private var operationId: Output<String>? = null

    private var policies: Output<String>? = null

    private var request: Output<RequestContractArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var responses: Output<List<ResponseContractArgs>>? = null

    private var serviceName: Output<String>? = null

    private var templateParameters: Output<List<ParameterContractArgs>>? = null

    private var urlTemplate: Output<String>? = null

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("asxsqbkoxktoeydo")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Description of the operation. May include HTML formatting tags.
     */
    @JvmName("oquibmunnuyrmwea")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Operation Name.
     */
    @JvmName("ctnwjxpfnrdxitdc")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
     */
    @JvmName("tqdvhbfqygyxdwoy")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Operation identifier within an API. Must be unique in the current API Management service instance.
     */
    @JvmName("knqljhygtheeudcw")
    public suspend fun operationId(`value`: Output<String>) {
        this.operationId = value
    }

    /**
     * @param value Operation Policies
     */
    @JvmName("uqeofbtjebhhoqqi")
    public suspend fun policies(`value`: Output<String>) {
        this.policies = value
    }

    /**
     * @param value An entity containing request details.
     */
    @JvmName("orrchyoutaptgjlt")
    public suspend fun request(`value`: Output<RequestContractArgs>) {
        this.request = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oxmflictgrqeiyut")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Array of Operation responses.
     */
    @JvmName("usdhcypwdkutwfdl")
    public suspend fun responses(`value`: Output<List<ResponseContractArgs>>) {
        this.responses = value
    }

    @JvmName("gcgpbexbkfcffaxo")
    public suspend fun responses(vararg values: Output<ResponseContractArgs>) {
        this.responses = Output.all(values.asList())
    }

    /**
     * @param values Array of Operation responses.
     */
    @JvmName("uwbiwltypjmtahif")
    public suspend fun responses(values: List<Output<ResponseContractArgs>>) {
        this.responses = Output.all(values)
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("uedkjtqufuplwbev")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Collection of URL template parameters.
     */
    @JvmName("xkpasqfhlbtqptsl")
    public suspend fun templateParameters(`value`: Output<List<ParameterContractArgs>>) {
        this.templateParameters = value
    }

    @JvmName("kwhxlonxxicldvyr")
    public suspend fun templateParameters(vararg values: Output<ParameterContractArgs>) {
        this.templateParameters = Output.all(values.asList())
    }

    /**
     * @param values Collection of URL template parameters.
     */
    @JvmName("hrvnautcjwncteal")
    public suspend fun templateParameters(values: List<Output<ParameterContractArgs>>) {
        this.templateParameters = Output.all(values)
    }

    /**
     * @param value Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
     */
    @JvmName("qdfnjycnprbhrrjf")
    public suspend fun urlTemplate(`value`: Output<String>) {
        this.urlTemplate = value
    }

    /**
     * @param value API revision identifier. Must be unique in the current API Management service instance. Non-current revision has ;rev=n as a suffix where n is the revision number.
     */
    @JvmName("rurwlnqhbeicwget")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Description of the operation. May include HTML formatting tags.
     */
    @JvmName("wimhhesnvmyqtwso")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Operation Name.
     */
    @JvmName("pwthspcvclflrsen")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not limited by only them.
     */
    @JvmName("rtqrtcdjqkdusrpa")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Operation identifier within an API. Must be unique in the current API Management service instance.
     */
    @JvmName("mrtvtphmdfnnljac")
    public suspend fun operationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationId = mapped
    }

    /**
     * @param value Operation Policies
     */
    @JvmName("drxmcrenewpepatp")
    public suspend fun policies(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param value An entity containing request details.
     */
    @JvmName("epwdbibukcalhbuk")
    public suspend fun request(`value`: RequestContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.request = mapped
    }

    /**
     * @param argument An entity containing request details.
     */
    @JvmName("cwykhcqpesldnemb")
    public suspend fun request(argument: suspend RequestContractArgsBuilder.() -> Unit) {
        val toBeMapped = RequestContractArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.request = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ndpucquyjvgdunhm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Array of Operation responses.
     */
    @JvmName("kkexsdbfkswekusy")
    public suspend fun responses(`value`: List<ResponseContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responses = mapped
    }

    /**
     * @param argument Array of Operation responses.
     */
    @JvmName("ygvprnmbrftrbuha")
    public suspend fun responses(argument: List<suspend ResponseContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResponseContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responses = mapped
    }

    /**
     * @param argument Array of Operation responses.
     */
    @JvmName("iurobncvsqmsrunu")
    public suspend fun responses(vararg argument: suspend ResponseContractArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResponseContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responses = mapped
    }

    /**
     * @param argument Array of Operation responses.
     */
    @JvmName("raemonjgqwrabwhy")
    public suspend fun responses(argument: suspend ResponseContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResponseContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.responses = mapped
    }

    /**
     * @param values Array of Operation responses.
     */
    @JvmName("tehtkhqhtjdaosbq")
    public suspend fun responses(vararg values: ResponseContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responses = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ivdysoatwccwmfhh")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Collection of URL template parameters.
     */
    @JvmName("ddnpmiaolipystxs")
    public suspend fun templateParameters(`value`: List<ParameterContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateParameters = mapped
    }

    /**
     * @param argument Collection of URL template parameters.
     */
    @JvmName("yviapfvxevidmcgh")
    public suspend
    fun templateParameters(argument: List<suspend ParameterContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.templateParameters = mapped
    }

    /**
     * @param argument Collection of URL template parameters.
     */
    @JvmName("nmlhwiluawwnhpsx")
    public suspend fun templateParameters(
        vararg
        argument: suspend ParameterContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.templateParameters = mapped
    }

    /**
     * @param argument Collection of URL template parameters.
     */
    @JvmName("mioinakncrsgtkbx")
    public suspend fun templateParameters(argument: suspend ParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.templateParameters = mapped
    }

    /**
     * @param values Collection of URL template parameters.
     */
    @JvmName("pfxshvjkhmjdlhms")
    public suspend fun templateParameters(vararg values: ParameterContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateParameters = mapped
    }

    /**
     * @param value Relative URL template identifying the target resource for this operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}
     */
    @JvmName("akdjkjqjsrhnmaar")
    public suspend fun urlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlTemplate = mapped
    }

    internal fun build(): ApiOperationArgs = ApiOperationArgs(
        apiId = apiId,
        description = description,
        displayName = displayName,
        method = method,
        operationId = operationId,
        policies = policies,
        request = request,
        resourceGroupName = resourceGroupName,
        responses = responses,
        serviceName = serviceName,
        templateParameters = templateParameters,
        urlTemplate = urlTemplate,
    )
}
