@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApiTagDescription].
 */
@PulumiTagMarker
public class ApiTagDescriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiTagDescriptionArgs = ApiTagDescriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiTagDescriptionArgsBuilder.() -> Unit) {
        val builder = ApiTagDescriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiTagDescription {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ApiTagDescription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApiTagDescription(builtJavaResource)
    }
}

/**
 * Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-01-01, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiTagDescription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiTagDescription = new AzureNative.ApiManagement.ApiTagDescription("apiTagDescription", new()
 *     {
 *         ApiId = "5931a75ae4bbd512a88c680b",
 *         Description = "Some description that will be displayed for operation's tag if the tag is assigned to operation of the API",
 *         ExternalDocsDescription = "Description of the external docs resource",
 *         ExternalDocsUrl = "http://some.url/additionaldoc",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagDescriptionId = "tagId1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiTagDescription(ctx, "apiTagDescription", &apimanagement.ApiTagDescriptionArgs{
 * 			ApiId:                   pulumi.String("5931a75ae4bbd512a88c680b"),
 * 			Description:             pulumi.String("Some description that will be displayed for operation's tag if the tag is assigned to operation of the API"),
 * 			ExternalDocsDescription: pulumi.String("Description of the external docs resource"),
 * 			ExternalDocsUrl:         pulumi.String("http://some.url/additionaldoc"),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 			ServiceName:             pulumi.String("apimService1"),
 * 			TagDescriptionId:        pulumi.String("tagId1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiTagDescription;
 * import com.pulumi.azurenative.apimanagement.ApiTagDescriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiTagDescription = new ApiTagDescription("apiTagDescription", ApiTagDescriptionArgs.builder()
 *             .apiId("5931a75ae4bbd512a88c680b")
 *             .description("Some description that will be displayed for operation's tag if the tag is assigned to operation of the API")
 *             .externalDocsDescription("Description of the external docs resource")
 *             .externalDocsUrl("http://some.url/additionaldoc")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagDescriptionId("tagId1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiTagDescription tagId1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/tagDescriptions/{tagDescriptionId}
 * ```
 */
public class ApiTagDescription internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ApiTagDescription,
) : KotlinCustomResource(javaResource, ApiTagDescriptionMapper) {
    /**
     * Description of the Tag.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tag name.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the external resources describing the tag.
     */
    public val externalDocsDescription: Output<String>?
        get() = javaResource.externalDocsDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Absolute URL of external resources describing the tag.
     */
    public val externalDocsUrl: Output<String>?
        get() = javaResource.externalDocsUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Identifier of the tag in the form of /tags/{tagId}
     */
    public val tagId: Output<String>?
        get() = javaResource.tagId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApiTagDescriptionMapper : ResourceMapper<ApiTagDescription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ApiTagDescription::class == javaResource::class

    override fun map(javaResource: Resource): ApiTagDescription = ApiTagDescription(
        javaResource as
            com.pulumi.azurenative.apimanagement.ApiTagDescription,
    )
}

/**
 * @see [ApiTagDescription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiTagDescription].
 */
public suspend fun apiTagDescription(
    name: String,
    block: suspend ApiTagDescriptionResourceBuilder.() -> Unit,
): ApiTagDescription {
    val builder = ApiTagDescriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiTagDescription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiTagDescription(name: String): ApiTagDescription {
    val builder = ApiTagDescriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
