@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ApiWikiArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.WikiDocumentationContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.WikiDocumentationContractArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Wiki properties
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateApiWiki
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiWiki = new AzureNative.ApiManagement.ApiWiki("apiWiki", new()
 *     {
 *         ApiId = "57d1f7558aa04f15146d9d8a",
 *         Documents = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.WikiDocumentationContractArgs
 *             {
 *                 DocumentationId = "docId1",
 *             },
 *             new AzureNative.ApiManagement.Inputs.WikiDocumentationContractArgs
 *             {
 *                 DocumentationId = "docId2",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewApiWiki(ctx, "apiWiki", &apimanagement.ApiWikiArgs{
 * 			ApiId: pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			Documents: []apimanagement.WikiDocumentationContractArgs{
 * 				{
 * 					DocumentationId: pulumi.String("docId1"),
 * 				},
 * 				{
 * 					DocumentationId: pulumi.String("docId2"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ApiWiki;
 * import com.pulumi.azurenative.apimanagement.ApiWikiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiWiki = new ApiWiki("apiWiki", ApiWikiArgs.builder()
 *             .apiId("57d1f7558aa04f15146d9d8a")
 *             .documents(
 *                 Map.of("documentationId", "docId1"),
 *                 Map.of("documentationId", "docId2"))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ApiWiki default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/wikis/default
 * ```
 * @property apiId API identifier. Must be unique in the current API Management service instance.
 * @property documents Collection wiki documents included into this wiki.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class ApiWikiArgs(
    public val apiId: Output<String>? = null,
    public val documents: Output<List<WikiDocumentationContractArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ApiWikiArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ApiWikiArgs =
        com.pulumi.azurenative.apimanagement.ApiWikiArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .documents(
                documents?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiWikiArgs].
 */
@PulumiTagMarker
public class ApiWikiArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var documents: Output<List<WikiDocumentationContractArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("thyjytqoexodyiks")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Collection wiki documents included into this wiki.
     */
    @JvmName("gsxiftehlcolemej")
    public suspend fun documents(`value`: Output<List<WikiDocumentationContractArgs>>) {
        this.documents = value
    }

    @JvmName("jshdsgdhteelfycd")
    public suspend fun documents(vararg values: Output<WikiDocumentationContractArgs>) {
        this.documents = Output.all(values.asList())
    }

    /**
     * @param values Collection wiki documents included into this wiki.
     */
    @JvmName("nelbfcoxjsqooepq")
    public suspend fun documents(values: List<Output<WikiDocumentationContractArgs>>) {
        this.documents = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qmsuxbulldgfwhog")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("xddduecpunehxqff")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value API identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jklhgkitsopasnvh")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Collection wiki documents included into this wiki.
     */
    @JvmName("uykujpubycdgiafk")
    public suspend fun documents(`value`: List<WikiDocumentationContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documents = mapped
    }

    /**
     * @param argument Collection wiki documents included into this wiki.
     */
    @JvmName("iurbbhjkywjkbnwu")
    public suspend
    fun documents(argument: List<suspend WikiDocumentationContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WikiDocumentationContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.documents = mapped
    }

    /**
     * @param argument Collection wiki documents included into this wiki.
     */
    @JvmName("xgtwkjbtakhuimel")
    public suspend fun documents(
        vararg
        argument: suspend WikiDocumentationContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WikiDocumentationContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.documents = mapped
    }

    /**
     * @param argument Collection wiki documents included into this wiki.
     */
    @JvmName("pmvntyflfschocqi")
    public suspend fun documents(argument: suspend WikiDocumentationContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WikiDocumentationContractArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.documents = mapped
    }

    /**
     * @param values Collection wiki documents included into this wiki.
     */
    @JvmName("hogrglxeylridxuq")
    public suspend fun documents(vararg values: WikiDocumentationContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.documents = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qtuhkofbqsghhqay")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jikdffqigumdidtj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ApiWikiArgs = ApiWikiArgs(
        apiId = apiId,
        documents = documents,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
