@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AuthorizationAccessPolicy].
 */
@PulumiTagMarker
public class AuthorizationAccessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizationAccessPolicyArgs = AuthorizationAccessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizationAccessPolicyArgsBuilder.() -> Unit) {
        val builder = AuthorizationAccessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AuthorizationAccessPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AuthorizationAccessPolicy(builtJavaResource)
    }
}

/**
 * Authorization access policy contract.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAuthorizationAccessPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var authorizationAccessPolicy = new AzureNative.ApiManagement.AuthorizationAccessPolicy("authorizationAccessPolicy", new()
 *     {
 *         AuthorizationAccessPolicyId = "fe0bed83-631f-4149-bd0b-0464b1bc7cab",
 *         AuthorizationId = "authz1",
 *         AuthorizationProviderId = "aadwithauthcode",
 *         ObjectId = "fe0bed83-631f-4149-bd0b-0464b1bc7cab",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TenantId = "13932a0d-5c63-4d37-901d-1df9c97722ff",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewAuthorizationAccessPolicy(ctx, "authorizationAccessPolicy", &apimanagement.AuthorizationAccessPolicyArgs{
 * 			AuthorizationAccessPolicyId: pulumi.String("fe0bed83-631f-4149-bd0b-0464b1bc7cab"),
 * 			AuthorizationId:             pulumi.String("authz1"),
 * 			AuthorizationProviderId:     pulumi.String("aadwithauthcode"),
 * 			ObjectId:                    pulumi.String("fe0bed83-631f-4149-bd0b-0464b1bc7cab"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 			ServiceName:                 pulumi.String("apimService1"),
 * 			TenantId:                    pulumi.String("13932a0d-5c63-4d37-901d-1df9c97722ff"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicy;
 * import com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var authorizationAccessPolicy = new AuthorizationAccessPolicy("authorizationAccessPolicy", AuthorizationAccessPolicyArgs.builder()
 *             .authorizationAccessPolicyId("fe0bed83-631f-4149-bd0b-0464b1bc7cab")
 *             .authorizationId("authz1")
 *             .authorizationProviderId("aadwithauthcode")
 *             .objectId("fe0bed83-631f-4149-bd0b-0464b1bc7cab")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tenantId("13932a0d-5c63-4d37-901d-1df9c97722ff")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:AuthorizationAccessPolicy fe0bed83-631f-4149-bd0b-0464b1bc7cab /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}
 * ```
 */
public class AuthorizationAccessPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicy,
) : KotlinCustomResource(javaResource, AuthorizationAccessPolicyMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Object Id
     */
    public val objectId: Output<String>?
        get() = javaResource.objectId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Tenant Id
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AuthorizationAccessPolicyMapper : ResourceMapper<AuthorizationAccessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AuthorizationAccessPolicy =
        AuthorizationAccessPolicy(
            javaResource as
                com.pulumi.azurenative.apimanagement.AuthorizationAccessPolicy,
        )
}

/**
 * @see [AuthorizationAccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AuthorizationAccessPolicy].
 */
public suspend fun authorizationAccessPolicy(
    name: String,
    block: suspend AuthorizationAccessPolicyResourceBuilder.() -> Unit,
): AuthorizationAccessPolicy {
    val builder = AuthorizationAccessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AuthorizationAccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorizationAccessPolicy(name: String): AuthorizationAccessPolicy {
    val builder = AuthorizationAccessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
