@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.BackendArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.BackendProtocol
import com.pulumi.azurenative.apimanagement.kotlin.inputs.BackendCredentialsContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.BackendCredentialsContractArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.BackendPropertiesArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.BackendPropertiesArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.BackendProxyContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.BackendProxyContractArgsBuilder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.BackendTlsPropertiesArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.BackendTlsPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Backend details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2018-01-01, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateBackendProxyBackend
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backend = new AzureNative.ApiManagement.Backend("backend", new()
 *     {
 *         BackendId = "proxybackend",
 *         Credentials = new AzureNative.ApiManagement.Inputs.BackendCredentialsContractArgs
 *         {
 *             Authorization = new AzureNative.ApiManagement.Inputs.BackendAuthorizationHeaderCredentialsArgs
 *             {
 *                 Parameter = "opensesma",
 *                 Scheme = "Basic",
 *             },
 *             Header =
 *             {
 *                 { "x-my-1", new[]
 *                 {
 *                     "val1",
 *                     "val2",
 *                 } },
 *             },
 *             Query =
 *             {
 *                 { "sv", new[]
 *                 {
 *                     "xx",
 *                     "bb",
 *                     "cc",
 *                 } },
 *             },
 *         },
 *         Description = "description5308",
 *         Protocol = "http",
 *         Proxy = new AzureNative.ApiManagement.Inputs.BackendProxyContractArgs
 *         {
 *             Password = "<password>",
 *             Url = "http://192.168.1.1:8080",
 *             Username = "Contoso\\admin",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Tls = new AzureNative.ApiManagement.Inputs.BackendTlsPropertiesArgs
 *         {
 *             ValidateCertificateChain = true,
 *             ValidateCertificateName = true,
 *         },
 *         Url = "https://backendname2644/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewBackend(ctx, "backend", &apimanagement.BackendArgs{
 * 			BackendId: pulumi.String("proxybackend"),
 * 			Credentials: apimanagement.BackendCredentialsContractResponse{
 * 				Authorization: &apimanagement.BackendAuthorizationHeaderCredentialsArgs{
 * 					Parameter: pulumi.String("opensesma"),
 * 					Scheme:    pulumi.String("Basic"),
 * 				},
 * 				Header: pulumi.StringArrayMap{
 * 					"x-my-1": pulumi.StringArray{
 * 						pulumi.String("val1"),
 * 						pulumi.String("val2"),
 * 					},
 * 				},
 * 				Query: pulumi.StringArrayMap{
 * 					"sv": pulumi.StringArray{
 * 						pulumi.String("xx"),
 * 						pulumi.String("bb"),
 * 						pulumi.String("cc"),
 * 					},
 * 				},
 * 			},
 * 			Description: pulumi.String("description5308"),
 * 			Protocol:    pulumi.String("http"),
 * 			Proxy: &apimanagement.BackendProxyContractArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Url:      pulumi.String("http://192.168.1.1:8080"),
 * 				Username: pulumi.String("Contoso\\admin"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Tls: &apimanagement.BackendTlsPropertiesArgs{
 * 				ValidateCertificateChain: pulumi.Bool(true),
 * 				ValidateCertificateName:  pulumi.Bool(true),
 * 			},
 * 			Url: pulumi.String("https://backendname2644/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Backend;
 * import com.pulumi.azurenative.apimanagement.BackendArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backend = new Backend("backend", BackendArgs.builder()
 *             .backendId("proxybackend")
 *             .credentials(Map.ofEntries(
 *                 Map.entry("authorization", Map.ofEntries(
 *                     Map.entry("parameter", "opensesma"),
 *                     Map.entry("scheme", "Basic")
 *                 )),
 *                 Map.entry("header", Map.of("x-my-1",
 *                     "val1",
 *                     "val2")),
 *                 Map.entry("query", Map.of("sv",
 *                     "xx",
 *                     "bb",
 *                     "cc"))
 *             ))
 *             .description("description5308")
 *             .protocol("http")
 *             .proxy(Map.ofEntries(
 *                 Map.entry("password", "<password>"),
 *                 Map.entry("url", "http://192.168.1.1:8080"),
 *                 Map.entry("username", "Contoso\\admin")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tls(Map.ofEntries(
 *                 Map.entry("validateCertificateChain", true),
 *                 Map.entry("validateCertificateName", true)
 *             ))
 *             .url("https://backendname2644/")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateBackendServiceFabric
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backend = new AzureNative.ApiManagement.Backend("backend", new()
 *     {
 *         BackendId = "sfbackend",
 *         Description = "Service Fabric Test App 1",
 *         Properties = new AzureNative.ApiManagement.Inputs.BackendPropertiesArgs
 *         {
 *             ServiceFabricCluster = new AzureNative.ApiManagement.Inputs.BackendServiceFabricClusterPropertiesArgs
 *             {
 *                 ClientCertificateId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1",
 *                 ManagementEndpoints = new[]
 *                 {
 *                     "https://somecluster.com",
 *                 },
 *                 MaxPartitionResolutionRetries = 5,
 *                 ServerX509Names = new[]
 *                 {
 *                     new AzureNative.ApiManagement.Inputs.X509CertificateNameArgs
 *                     {
 *                         IssuerCertificateThumbprint = "IssuerCertificateThumbprint1",
 *                         Name = "ServerCommonName1",
 *                     },
 *                 },
 *             },
 *         },
 *         Protocol = "http",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Url = "fabric:/mytestapp/mytestservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := apimanagement.NewBackend(ctx, "backend", &apimanagement.BackendArgs{
 * BackendId: pulumi.String("sfbackend"),
 * Description: pulumi.String("Service Fabric Test App 1"),
 * Properties: apimanagement.BackendPropertiesResponse{
 * ServiceFabricCluster: interface{}{
 * ClientCertificateId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1"),
 * ManagementEndpoints: pulumi.StringArray{
 * pulumi.String("https://somecluster.com"),
 * },
 * MaxPartitionResolutionRetries: pulumi.Int(5),
 * ServerX509Names: apimanagement.X509CertificateNameArray{
 * &apimanagement.X509CertificateNameArgs{
 * IssuerCertificateThumbprint: pulumi.String("IssuerCertificateThumbprint1"),
 * Name: pulumi.String("ServerCommonName1"),
 * },
 * },
 * },
 * },
 * Protocol: pulumi.String("http"),
 * ResourceGroupName: pulumi.String("rg1"),
 * ServiceName: pulumi.String("apimService1"),
 * Url: pulumi.String("fabric:/mytestapp/mytestservice"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Backend;
 * import com.pulumi.azurenative.apimanagement.BackendArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backend = new Backend("backend", BackendArgs.builder()
 *             .backendId("sfbackend")
 *             .description("Service Fabric Test App 1")
 *             .properties(Map.of("serviceFabricCluster", Map.ofEntries(
 *                 Map.entry("clientCertificateId", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/certificates/cert1"),
 *                 Map.entry("managementEndpoints", "https://somecluster.com"),
 *                 Map.entry("maxPartitionResolutionRetries", 5),
 *                 Map.entry("serverX509Names", Map.ofEntries(
 *                     Map.entry("issuerCertificateThumbprint", "IssuerCertificateThumbprint1"),
 *                     Map.entry("name", "ServerCommonName1")
 *                 ))
 *             )))
 *             .protocol("http")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .url("fabric:/mytestapp/mytestservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Backend sfbackend /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/backends/{backendId}
 * ```
 * @property backendId Identifier of the Backend entity. Must be unique in the current API Management service instance.
 * @property credentials Backend Credentials Contract Properties
 * @property description Backend Description.
 * @property properties Backend Properties contract
 * @property protocol Backend communication protocol.
 * @property proxy Backend gateway Contract Properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceId Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or API Apps.
 * @property serviceName The name of the API Management service.
 * @property title Backend Title.
 * @property tls Backend TLS Properties
 * @property url Runtime Url of the Backend.
 */
public data class BackendArgs(
    public val backendId: Output<String>? = null,
    public val credentials: Output<BackendCredentialsContractArgs>? = null,
    public val description: Output<String>? = null,
    public val properties: Output<BackendPropertiesArgs>? = null,
    public val protocol: Output<Either<String, BackendProtocol>>? = null,
    public val proxy: Output<BackendProxyContractArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val title: Output<String>? = null,
    public val tls: Output<BackendTlsPropertiesArgs>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.BackendArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.BackendArgs =
        com.pulumi.azurenative.apimanagement.BackendArgs.builder()
            .backendId(backendId?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .proxy(proxy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendArgs].
 */
@PulumiTagMarker
public class BackendArgsBuilder internal constructor() {
    private var backendId: Output<String>? = null

    private var credentials: Output<BackendCredentialsContractArgs>? = null

    private var description: Output<String>? = null

    private var properties: Output<BackendPropertiesArgs>? = null

    private var protocol: Output<Either<String, BackendProtocol>>? = null

    private var proxy: Output<BackendProxyContractArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var title: Output<String>? = null

    private var tls: Output<BackendTlsPropertiesArgs>? = null

    private var url: Output<String>? = null

    /**
     * @param value Identifier of the Backend entity. Must be unique in the current API Management service instance.
     */
    @JvmName("cdtkvrsregrkvqqu")
    public suspend fun backendId(`value`: Output<String>) {
        this.backendId = value
    }

    /**
     * @param value Backend Credentials Contract Properties
     */
    @JvmName("ikhafkjaxncbvedv")
    public suspend fun credentials(`value`: Output<BackendCredentialsContractArgs>) {
        this.credentials = value
    }

    /**
     * @param value Backend Description.
     */
    @JvmName("ikikrpodaohfcetc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Backend Properties contract
     */
    @JvmName("omldrivoehsldykn")
    public suspend fun properties(`value`: Output<BackendPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Backend communication protocol.
     */
    @JvmName("cfbytnncasmbuxaa")
    public suspend fun protocol(`value`: Output<Either<String, BackendProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Backend gateway Contract Properties
     */
    @JvmName("mvmjlcaevtbaackg")
    public suspend fun proxy(`value`: Output<BackendProxyContractArgs>) {
        this.proxy = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rfjockfxvtbeqesb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or API Apps.
     */
    @JvmName("ycqjixoiegtqwhru")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("cvnwwpsiaasinlld")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Backend Title.
     */
    @JvmName("ldkfjyrjmjnvfdto")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Backend TLS Properties
     */
    @JvmName("ennvmlslvtgoavdx")
    public suspend fun tls(`value`: Output<BackendTlsPropertiesArgs>) {
        this.tls = value
    }

    /**
     * @param value Runtime Url of the Backend.
     */
    @JvmName("eksijebyfstjdbsa")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Identifier of the Backend entity. Must be unique in the current API Management service instance.
     */
    @JvmName("pnmrgboqijyimhnh")
    public suspend fun backendId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendId = mapped
    }

    /**
     * @param value Backend Credentials Contract Properties
     */
    @JvmName("ovuxwbjjvapyfagi")
    public suspend fun credentials(`value`: BackendCredentialsContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Backend Credentials Contract Properties
     */
    @JvmName("jjbvbrkqhpfyplkl")
    public suspend
    fun credentials(argument: suspend BackendCredentialsContractArgsBuilder.() -> Unit) {
        val toBeMapped = BackendCredentialsContractArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value Backend Description.
     */
    @JvmName("jblltmquglolnafd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Backend Properties contract
     */
    @JvmName("hakawshpycappfhd")
    public suspend fun properties(`value`: BackendPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Backend Properties contract
     */
    @JvmName("usnihrpouyyomsbt")
    public suspend fun properties(argument: suspend BackendPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BackendPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Backend communication protocol.
     */
    @JvmName("mwxeudaedlgnvguk")
    public suspend fun protocol(`value`: Either<String, BackendProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Backend communication protocol.
     */
    @JvmName("kxgrdikapdtxlaxv")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackendProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Backend communication protocol.
     */
    @JvmName("vniqvbpkhlfigago")
    public fun protocol(`value`: BackendProtocol) {
        val toBeMapped = Either.ofRight<String, BackendProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Backend gateway Contract Properties
     */
    @JvmName("fmtmlhiiobmcniqk")
    public suspend fun proxy(`value`: BackendProxyContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxy = mapped
    }

    /**
     * @param argument Backend gateway Contract Properties
     */
    @JvmName("lthlclkvdkdopasr")
    public suspend fun proxy(argument: suspend BackendProxyContractArgsBuilder.() -> Unit) {
        val toBeMapped = BackendProxyContractArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.proxy = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hkiaotksaothpdqh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or API Apps.
     */
    @JvmName("gexlyviluonjomny")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("kchbguycjcuehbem")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Backend Title.
     */
    @JvmName("ovycvhowfkkvpdhk")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value Backend TLS Properties
     */
    @JvmName("kpjuxocwdvqovsws")
    public suspend fun tls(`value`: BackendTlsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument Backend TLS Properties
     */
    @JvmName("gwekrddywebdjeam")
    public suspend fun tls(argument: suspend BackendTlsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BackendTlsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    /**
     * @param value Runtime Url of the Backend.
     */
    @JvmName("phieeyfarifbwdtm")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): BackendArgs = BackendArgs(
        backendId = backendId,
        credentials = credentials,
        description = description,
        properties = properties,
        protocol = protocol,
        proxy = proxy,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        serviceName = serviceName,
        title = title,
        tls = tls,
        url = url,
    )
}
