@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.CacheArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cache details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2019-12-01-preview, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateCache
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cache = new AzureNative.ApiManagement.Cache("cache", new()
 *     {
 *         CacheId = "c1",
 *         ConnectionString = "apim.redis.cache.windows.net:6380,password=xc,ssl=True,abortConnect=False",
 *         Description = "Redis cache instances in West India",
 *         ResourceGroupName = "rg1",
 *         ResourceId = "https://management.azure.com/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/redis/apimservice1",
 *         ServiceName = "apimService1",
 *         UseFromLocation = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewCache(ctx, "cache", &apimanagement.CacheArgs{
 * 			CacheId:           pulumi.String("c1"),
 * 			ConnectionString:  pulumi.String("apim.redis.cache.windows.net:6380,password=xc,ssl=True,abortConnect=False"),
 * 			Description:       pulumi.String("Redis cache instances in West India"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceId:        pulumi.String("https://management.azure.com/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/redis/apimservice1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			UseFromLocation:   pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Cache;
 * import com.pulumi.azurenative.apimanagement.CacheArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cache = new Cache("cache", CacheArgs.builder()
 *             .cacheId("c1")
 *             .connectionString("apim.redis.cache.windows.net:6380,password=xc,ssl=True,abortConnect=False")
 *             .description("Redis cache instances in West India")
 *             .resourceGroupName("rg1")
 *             .resourceId("https://management.azure.com/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/redis/apimservice1")
 *             .serviceName("apimService1")
 *             .useFromLocation("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Cache c1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/caches/{cacheId}
 * ```
 * @property cacheId Identifier of the Cache entity. Cache identifier (should be either 'default' or valid Azure region identifier).
 * @property connectionString Runtime connection string to cache
 * @property description Cache description
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceId Original uri of entity in external system cache points to
 * @property serviceName The name of the API Management service.
 * @property useFromLocation Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
 */
public data class CacheArgs(
    public val cacheId: Output<String>? = null,
    public val connectionString: Output<String>? = null,
    public val description: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val useFromLocation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.CacheArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.CacheArgs =
        com.pulumi.azurenative.apimanagement.CacheArgs.builder()
            .cacheId(cacheId?.applyValue({ args0 -> args0 }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .useFromLocation(useFromLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheArgs].
 */
@PulumiTagMarker
public class CacheArgsBuilder internal constructor() {
    private var cacheId: Output<String>? = null

    private var connectionString: Output<String>? = null

    private var description: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var useFromLocation: Output<String>? = null

    /**
     * @param value Identifier of the Cache entity. Cache identifier (should be either 'default' or valid Azure region identifier).
     */
    @JvmName("pqthenrvknjltsny")
    public suspend fun cacheId(`value`: Output<String>) {
        this.cacheId = value
    }

    /**
     * @param value Runtime connection string to cache
     */
    @JvmName("oeefecdsjmkoqmvg")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value Cache description
     */
    @JvmName("oxvfnqvonuafhptf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gcanjisjiymwewdy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Original uri of entity in external system cache points to
     */
    @JvmName("istquvrvbgqtkiqr")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("slamghxambqntxik")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
     */
    @JvmName("thimnqahwpirjeyv")
    public suspend fun useFromLocation(`value`: Output<String>) {
        this.useFromLocation = value
    }

    /**
     * @param value Identifier of the Cache entity. Cache identifier (should be either 'default' or valid Azure region identifier).
     */
    @JvmName("fkxwxduadmaueayn")
    public suspend fun cacheId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheId = mapped
    }

    /**
     * @param value Runtime connection string to cache
     */
    @JvmName("ejvivoxpkxjacisu")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Cache description
     */
    @JvmName("mqtwdnkptiasdarm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ufoovvrvolixwurq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Original uri of entity in external system cache points to
     */
    @JvmName("rjtleyjboucaxvff")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("yklkrgoakfpagbqt")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Location identifier to use cache from (should be either 'default' or valid Azure region identifier)
     */
    @JvmName("auccjmeexodyqlyx")
    public suspend fun useFromLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useFromLocation = mapped
    }

    internal fun build(): CacheArgs = CacheArgs(
        cacheId = cacheId,
        connectionString = connectionString,
        description = description,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        serviceName = serviceName,
        useFromLocation = useFromLocation,
    )
}
