@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.CertificateArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.KeyVaultContractCreatePropertiesArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.KeyVaultContractCreatePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Certificate details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateCertificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.ApiManagement.Certificate("certificate", new()
 *     {
 *         CertificateId = "tempcert",
 *         Data = "****************Base 64 Encoded Certificate *******************************",
 *         Password = "****Certificate Password******",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewCertificate(ctx, "certificate", &apimanagement.CertificateArgs{
 * 			CertificateId:     pulumi.String("tempcert"),
 * 			Data:              pulumi.String("****************Base 64 Encoded Certificate *******************************"),
 * 			Password:          pulumi.String("****Certificate Password******"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Certificate;
 * import com.pulumi.azurenative.apimanagement.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .certificateId("tempcert")
 *             .data("****************Base 64 Encoded Certificate *******************************")
 *             .password("****Certificate Password******")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateCertificateWithKeyVault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.ApiManagement.Certificate("certificate", new()
 *     {
 *         CertificateId = "templateCertkv",
 *         KeyVault = new AzureNative.ApiManagement.Inputs.KeyVaultContractCreatePropertiesArgs
 *         {
 *             IdentityClientId = "ceaa6b06-c00f-43ef-99ac-f53d1fe876a0",
 *             SecretIdentifier = "https://rpbvtkeyvaultintegration.vault-int.azure-int.net/secrets/msitestingCert",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewCertificate(ctx, "certificate", &apimanagement.CertificateArgs{
 * 			CertificateId: pulumi.String("templateCertkv"),
 * 			KeyVault: &apimanagement.KeyVaultContractCreatePropertiesArgs{
 * 				IdentityClientId: pulumi.String("ceaa6b06-c00f-43ef-99ac-f53d1fe876a0"),
 * 				SecretIdentifier: pulumi.String("https://rpbvtkeyvaultintegration.vault-int.azure-int.net/secrets/msitestingCert"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Certificate;
 * import com.pulumi.azurenative.apimanagement.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .certificateId("templateCertkv")
 *             .keyVault(Map.ofEntries(
 *                 Map.entry("identityClientId", "ceaa6b06-c00f-43ef-99ac-f53d1fe876a0"),
 *                 Map.entry("secretIdentifier", "https://rpbvtkeyvaultintegration.vault-int.azure-int.net/secrets/msitestingCert")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Certificate templateCertkv /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/certificates/{certificateId}
 * ```
 * @property certificateId Identifier of the certificate entity. Must be unique in the current API Management service instance.
 * @property data Base 64 encoded certificate using the application/x-pkcs12 representation.
 * @property keyVault KeyVault location details of the certificate.
 * @property password Password for the Certificate
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class CertificateArgs(
    public val certificateId: Output<String>? = null,
    public val `data`: Output<String>? = null,
    public val keyVault: Output<KeyVaultContractCreatePropertiesArgs>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.CertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.CertificateArgs =
        com.pulumi.azurenative.apimanagement.CertificateArgs.builder()
            .certificateId(certificateId?.applyValue({ args0 -> args0 }))
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var certificateId: Output<String>? = null

    private var `data`: Output<String>? = null

    private var keyVault: Output<KeyVaultContractCreatePropertiesArgs>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Identifier of the certificate entity. Must be unique in the current API Management service instance.
     */
    @JvmName("pkikavemadbuvaee")
    public suspend fun certificateId(`value`: Output<String>) {
        this.certificateId = value
    }

    /**
     * @param value Base 64 encoded certificate using the application/x-pkcs12 representation.
     */
    @JvmName("wxcdekpnkrjivkuq")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value KeyVault location details of the certificate.
     */
    @JvmName("grfjqvwfobkcaiuh")
    public suspend fun keyVault(`value`: Output<KeyVaultContractCreatePropertiesArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Password for the Certificate
     */
    @JvmName("wgdhhqvkcyqtvjxx")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jdcgxkegtpxdptqy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("herflilpjjwaglip")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Identifier of the certificate entity. Must be unique in the current API Management service instance.
     */
    @JvmName("kcjmobyevxecuuqr")
    public suspend fun certificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateId = mapped
    }

    /**
     * @param value Base 64 encoded certificate using the application/x-pkcs12 representation.
     */
    @JvmName("bfogjbbsnmfmfkyh")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value KeyVault location details of the certificate.
     */
    @JvmName("siopreiakkfjhrxs")
    public suspend fun keyVault(`value`: KeyVaultContractCreatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument KeyVault location details of the certificate.
     */
    @JvmName("jykonfbqikecifcg")
    public suspend
    fun keyVault(argument: suspend KeyVaultContractCreatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultContractCreatePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Password for the Certificate
     */
    @JvmName("uwxvaivudhmrpllh")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yymjytklepwwpvix")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("klqirjloampxqljr")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        certificateId = certificateId,
        `data` = `data`,
        keyVault = keyVault,
        password = password,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
