@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ContentItem].
 */
@PulumiTagMarker
public class ContentItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContentItemArgs = ContentItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContentItemArgsBuilder.() -> Unit) {
        val builder = ContentItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContentItem {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ContentItem(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContentItem(builtJavaResource)
    }
}

/**
 * Content type contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateContentTypeContentItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentItem = new AzureNative.ApiManagement.ContentItem("contentItem", new()
 *     {
 *         ContentItemId = "4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8",
 *         ContentTypeId = "page",
 *         Properties =
 *         {
 *             { "en_us",
 *             {
 *                 { "description", "Short story about the company." },
 *                 { "documentId", "contentTypes/document/contentItems/4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8" },
 *                 { "keywords", "company, about" },
 *                 { "permalink", "/about" },
 *                 { "title", "About" },
 *             } },
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewContentItem(ctx, "contentItem", &apimanagement.ContentItemArgs{
 * 			ContentItemId: pulumi.String("4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8"),
 * 			ContentTypeId: pulumi.String("page"),
 * 			Properties: pulumi.Any{
 * 				En_us: map[string]interface{}{
 * 					"description": "Short story about the company.",
 * 					"documentId":  "contentTypes/document/contentItems/4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8",
 * 					"keywords":    "company, about",
 * 					"permalink":   "/about",
 * 					"title":       "About",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ContentItem;
 * import com.pulumi.azurenative.apimanagement.ContentItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentItem = new ContentItem("contentItem", ContentItemArgs.builder()
 *             .contentItemId("4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8")
 *             .contentTypeId("page")
 *             .properties(Map.of("en_us", Map.ofEntries(
 *                 Map.entry("description", "Short story about the company."),
 *                 Map.entry("documentId", "contentTypes/document/contentItems/4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8"),
 *                 Map.entry("keywords", "company, about"),
 *                 Map.entry("permalink", "/about"),
 *                 Map.entry("title", "About")
 *             )))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ContentItem 4e3cf6a5-574a-ba08-1f23-2e7a38faa6d8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/contentTypes/{contentTypeId}/contentItems/{contentItemId}
 * ```
 */
public class ContentItem internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ContentItem,
) : KotlinCustomResource(javaResource, ContentItemMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the content item.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContentItemMapper : ResourceMapper<ContentItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ContentItem::class == javaResource::class

    override fun map(javaResource: Resource): ContentItem = ContentItem(
        javaResource as
            com.pulumi.azurenative.apimanagement.ContentItem,
    )
}

/**
 * @see [ContentItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContentItem].
 */
public suspend fun contentItem(name: String, block: suspend ContentItemResourceBuilder.() -> Unit):
    ContentItem {
    val builder = ContentItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContentItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contentItem(name: String): ContentItem {
    val builder = ContentItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
