@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ContentType].
 */
@PulumiTagMarker
public class ContentTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContentTypeArgs = ContentTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContentTypeArgsBuilder.() -> Unit) {
        val builder = ContentTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContentType {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ContentType(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContentType(builtJavaResource)
    }
}

/**
 * Content type contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateContentType
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contentType = new AzureNative.ApiManagement.ContentType("contentType", new()
 *     {
 *         ContentTypeId = "page",
 *         Description = "A regular page",
 *         Name = "Page",
 *         ResourceGroupName = "rg1",
 *         Schema =
 *         {
 *             { "additionalProperties", false },
 *             { "properties",
 *             {
 *                 { "en_us",
 *                 {
 *                     { "additionalProperties", false },
 *                     { "properties",
 *                     {
 *                         { "description",
 *                         {
 *                             { "description", "Page description. This property gets included in SEO attributes." },
 *                             { "indexed", true },
 *                             { "title", "Description" },
 *                             { "type", "string" },
 *                         } },
 *                         { "documentId",
 *                         {
 *                             { "description", "Reference to page content document." },
 *                             { "title", "Document ID" },
 *                             { "type", "string" },
 *                         } },
 *                         { "keywords",
 *                         {
 *                             { "description", "Page keywords. This property gets included in SEO attributes." },
 *                             { "indexed", true },
 *                             { "title", "Keywords" },
 *                             { "type", "string" },
 *                         } },
 *                         { "permalink",
 *                         {
 *                             { "description", "Page permalink, e.g. '/about'." },
 *                             { "indexed", true },
 *                             { "title", "Permalink" },
 *                             { "type", "string" },
 *                         } },
 *                         { "title",
 *                         {
 *                             { "description", "Page title. This property gets included in SEO attributes." },
 *                             { "indexed", true },
 *                             { "title", "Title" },
 *                             { "type", "string" },
 *                         } },
 *                     } },
 *                     { "required", new[]
 *                     {
 *                         "title",
 *                         "permalink",
 *                         "documentId",
 *                     } },
 *                     { "type", "object" },
 *                 } },
 *             } },
 *         },
 *         ServiceName = "apimService1",
 *         Version = "1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewContentType(ctx, "contentType", &apimanagement.ContentTypeArgs{
 * 			ContentTypeId:     pulumi.String("page"),
 * 			Description:       pulumi.String("A regular page"),
 * 			Name:              pulumi.String("Page"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Schema: pulumi.Any{
 * 				AdditionalProperties: false,
 * 				Properties: map[string]interface{}{
 * 					"en_us": map[string]interface{}{
 * 						"additionalProperties": false,
 * 						"properties": map[string]interface{}{
 * 							"description": map[string]interface{}{
 * 								"description": "Page description. This property gets included in SEO attributes.",
 * 								"indexed":     true,
 * 								"title":       "Description",
 * 								"type":        "string",
 * 							},
 * 							"documentId": map[string]interface{}{
 * 								"description": "Reference to page content document.",
 * 								"title":       "Document ID",
 * 								"type":        "string",
 * 							},
 * 							"keywords": map[string]interface{}{
 * 								"description": "Page keywords. This property gets included in SEO attributes.",
 * 								"indexed":     true,
 * 								"title":       "Keywords",
 * 								"type":        "string",
 * 							},
 * 							"permalink": map[string]interface{}{
 * 								"description": "Page permalink, e.g. '/about'.",
 * 								"indexed":     true,
 * 								"title":       "Permalink",
 * 								"type":        "string",
 * 							},
 * 							"title": map[string]interface{}{
 * 								"description": "Page title. This property gets included in SEO attributes.",
 * 								"indexed":     true,
 * 								"title":       "Title",
 * 								"type":        "string",
 * 							},
 * 						},
 * 						"required": []string{
 * 							"title",
 * 							"permalink",
 * 							"documentId",
 * 						},
 * 						"type": "object",
 * 					},
 * 				},
 * 			},
 * 			ServiceName: pulumi.String("apimService1"),
 * 			Version:     pulumi.String("1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ContentType;
 * import com.pulumi.azurenative.apimanagement.ContentTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contentType = new ContentType("contentType", ContentTypeArgs.builder()
 *             .contentTypeId("page")
 *             .description("A regular page")
 *             .name("Page")
 *             .resourceGroupName("rg1")
 *             .schema(Map.ofEntries(
 *                 Map.entry("additionalProperties", false),
 *                 Map.entry("properties", Map.of("en_us", Map.ofEntries(
 *                     Map.entry("additionalProperties", false),
 *                     Map.entry("properties", Map.ofEntries(
 *                         Map.entry("description", Map.ofEntries(
 *                             Map.entry("description", "Page description. This property gets included in SEO attributes."),
 *                             Map.entry("indexed", true),
 *                             Map.entry("title", "Description"),
 *                             Map.entry("type", "string")
 *                         )),
 *                         Map.entry("documentId", Map.ofEntries(
 *                             Map.entry("description", "Reference to page content document."),
 *                             Map.entry("title", "Document ID"),
 *                             Map.entry("type", "string")
 *                         )),
 *                         Map.entry("keywords", Map.ofEntries(
 *                             Map.entry("description", "Page keywords. This property gets included in SEO attributes."),
 *                             Map.entry("indexed", true),
 *                             Map.entry("title", "Keywords"),
 *                             Map.entry("type", "string")
 *                         )),
 *                         Map.entry("permalink", Map.ofEntries(
 *                             Map.entry("description", "Page permalink, e.g. '/about'."),
 *                             Map.entry("indexed", true),
 *                             Map.entry("title", "Permalink"),
 *                             Map.entry("type", "string")
 *                         )),
 *                         Map.entry("title", Map.ofEntries(
 *                             Map.entry("description", "Page title. This property gets included in SEO attributes."),
 *                             Map.entry("indexed", true),
 *                             Map.entry("title", "Title"),
 *                             Map.entry("type", "string")
 *                         ))
 *                     )),
 *                     Map.entry("required",
 *                         "title",
 *                         "permalink",
 *                         "documentId"),
 *                     Map.entry("type", "object")
 *                 )))
 *             ))
 *             .serviceName("apimService1")
 *             .version("1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ContentType page /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/contentTypes/{contentTypeId}
 * ```
 */
public class ContentType internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ContentType,
) : KotlinCustomResource(javaResource, ContentTypeMapper) {
    /**
     * Content type description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Content type schema.
     */
    public val schema: Output<Any>?
        get() = javaResource.schema().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Content type version.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ContentTypeMapper : ResourceMapper<ContentType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ContentType::class == javaResource::class

    override fun map(javaResource: Resource): ContentType = ContentType(
        javaResource as
            com.pulumi.azurenative.apimanagement.ContentType,
    )
}

/**
 * @see [ContentType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContentType].
 */
public suspend fun contentType(name: String, block: suspend ContentTypeResourceBuilder.() -> Unit):
    ContentType {
    val builder = ContentTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContentType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contentType(name: String): ContentType {
    val builder = ContentTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
