@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.PipelineDiagnosticSettingsResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.SamplingSettingsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.apimanagement.kotlin.outputs.PipelineDiagnosticSettingsResponse.Companion.toKotlin as pipelineDiagnosticSettingsResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.SamplingSettingsResponse.Companion.toKotlin as samplingSettingsResponseToKotlin

/**
 * Builder for [Diagnostic].
 */
@PulumiTagMarker
public class DiagnosticResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiagnosticArgs = DiagnosticArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiagnosticArgsBuilder.() -> Unit) {
        val builder = DiagnosticArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Diagnostic {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.Diagnostic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Diagnostic(builtJavaResource)
    }
}

/**
 * Diagnostic details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2018-01-01, 2019-01-01, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateDiagnostic
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnostic = new AzureNative.ApiManagement.Diagnostic("diagnostic", new()
 *     {
 *         AlwaysLog = "allErrors",
 *         Backend = new AzureNative.ApiManagement.Inputs.PipelineDiagnosticSettingsArgs
 *         {
 *             Request = new AzureNative.ApiManagement.Inputs.HttpMessageDiagnosticArgs
 *             {
 *                 Body = new AzureNative.ApiManagement.Inputs.BodyDiagnosticSettingsArgs
 *                 {
 *                     Bytes = 512,
 *                 },
 *                 Headers = new[]
 *                 {
 *                     "Content-type",
 *                 },
 *             },
 *             Response = new AzureNative.ApiManagement.Inputs.HttpMessageDiagnosticArgs
 *             {
 *                 Body = new AzureNative.ApiManagement.Inputs.BodyDiagnosticSettingsArgs
 *                 {
 *                     Bytes = 512,
 *                 },
 *                 Headers = new[]
 *                 {
 *                     "Content-type",
 *                 },
 *             },
 *         },
 *         DiagnosticId = "applicationinsights",
 *         Frontend = new AzureNative.ApiManagement.Inputs.PipelineDiagnosticSettingsArgs
 *         {
 *             Request = new AzureNative.ApiManagement.Inputs.HttpMessageDiagnosticArgs
 *             {
 *                 Body = new AzureNative.ApiManagement.Inputs.BodyDiagnosticSettingsArgs
 *                 {
 *                     Bytes = 512,
 *                 },
 *                 Headers = new[]
 *                 {
 *                     "Content-type",
 *                 },
 *             },
 *             Response = new AzureNative.ApiManagement.Inputs.HttpMessageDiagnosticArgs
 *             {
 *                 Body = new AzureNative.ApiManagement.Inputs.BodyDiagnosticSettingsArgs
 *                 {
 *                     Bytes = 512,
 *                 },
 *                 Headers = new[]
 *                 {
 *                     "Content-type",
 *                 },
 *             },
 *         },
 *         LoggerId = "/loggers/azuremonitor",
 *         ResourceGroupName = "rg1",
 *         Sampling = new AzureNative.ApiManagement.Inputs.SamplingSettingsArgs
 *         {
 *             Percentage = 50,
 *             SamplingType = "fixed",
 *         },
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := apimanagement.NewDiagnostic(ctx, "diagnostic", &apimanagement.DiagnosticArgs{
 * AlwaysLog: pulumi.String("allErrors"),
 * Backend: apimanagement.PipelineDiagnosticSettingsResponse{
 * Request: interface{}{
 * Body: &apimanagement.BodyDiagnosticSettingsArgs{
 * Bytes: pulumi.Int(512),
 * },
 * Headers: pulumi.StringArray{
 * pulumi.String("Content-type"),
 * },
 * },
 * Response: interface{}{
 * Body: &apimanagement.BodyDiagnosticSettingsArgs{
 * Bytes: pulumi.Int(512),
 * },
 * Headers: pulumi.StringArray{
 * pulumi.String("Content-type"),
 * },
 * },
 * },
 * DiagnosticId: pulumi.String("applicationinsights"),
 * Frontend: apimanagement.PipelineDiagnosticSettingsResponse{
 * Request: interface{}{
 * Body: &apimanagement.BodyDiagnosticSettingsArgs{
 * Bytes: pulumi.Int(512),
 * },
 * Headers: pulumi.StringArray{
 * pulumi.String("Content-type"),
 * },
 * },
 * Response: interface{}{
 * Body: &apimanagement.BodyDiagnosticSettingsArgs{
 * Bytes: pulumi.Int(512),
 * },
 * Headers: pulumi.StringArray{
 * pulumi.String("Content-type"),
 * },
 * },
 * },
 * LoggerId: pulumi.String("/loggers/azuremonitor"),
 * ResourceGroupName: pulumi.String("rg1"),
 * Sampling: &apimanagement.SamplingSettingsArgs{
 * Percentage: pulumi.Float64(50),
 * SamplingType: pulumi.String("fixed"),
 * },
 * ServiceName: pulumi.String("apimService1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Diagnostic;
 * import com.pulumi.azurenative.apimanagement.DiagnosticArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnostic = new Diagnostic("diagnostic", DiagnosticArgs.builder()
 *             .alwaysLog("allErrors")
 *             .backend(Map.ofEntries(
 *                 Map.entry("request", Map.ofEntries(
 *                     Map.entry("body", Map.of("bytes", 512)),
 *                     Map.entry("headers", "Content-type")
 *                 )),
 *                 Map.entry("response", Map.ofEntries(
 *                     Map.entry("body", Map.of("bytes", 512)),
 *                     Map.entry("headers", "Content-type")
 *                 ))
 *             ))
 *             .diagnosticId("applicationinsights")
 *             .frontend(Map.ofEntries(
 *                 Map.entry("request", Map.ofEntries(
 *                     Map.entry("body", Map.of("bytes", 512)),
 *                     Map.entry("headers", "Content-type")
 *                 )),
 *                 Map.entry("response", Map.ofEntries(
 *                     Map.entry("body", Map.of("bytes", 512)),
 *                     Map.entry("headers", "Content-type")
 *                 ))
 *             ))
 *             .loggerId("/loggers/azuremonitor")
 *             .resourceGroupName("rg1")
 *             .sampling(Map.ofEntries(
 *                 Map.entry("percentage", 50),
 *                 Map.entry("samplingType", "fixed")
 *             ))
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Diagnostic applicationinsights /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/diagnostics/{diagnosticId}
 * ```
 */
public class Diagnostic internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.Diagnostic,
) : KotlinCustomResource(javaResource, DiagnosticMapper) {
    /**
     * Specifies for what type of messages sampling settings should not apply.
     */
    public val alwaysLog: Output<String>?
        get() = javaResource.alwaysLog().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Diagnostic settings for incoming/outgoing HTTP messages to the Backend
     */
    public val backend: Output<PipelineDiagnosticSettingsResponse>?
        get() = javaResource.backend().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelineDiagnosticSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
     */
    public val frontend: Output<PipelineDiagnosticSettingsResponse>?
        get() = javaResource.frontend().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    pipelineDiagnosticSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Sets correlation protocol to use for Application Insights diagnostics.
     */
    public val httpCorrelationProtocol: Output<String>?
        get() = javaResource.httpCorrelationProtocol().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Log the ClientIP. Default is false.
     */
    public val logClientIp: Output<Boolean>?
        get() = javaResource.logClientIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Id of a target logger.
     */
    public val loggerId: Output<String>
        get() = javaResource.loggerId().applyValue({ args0 -> args0 })

    /**
     * Emit custom metrics via emit-metric policy. Applicable only to Application Insights diagnostic settings.
     */
    public val metrics: Output<Boolean>?
        get() = javaResource.metrics().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The format of the Operation Name for Application Insights telemetries. Default is Name.
     */
    public val operationNameFormat: Output<String>?
        get() = javaResource.operationNameFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sampling settings for Diagnostic.
     */
    public val sampling: Output<SamplingSettingsResponse>?
        get() = javaResource.sampling().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    samplingSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The verbosity level applied to traces emitted by trace policies.
     */
    public val verbosity: Output<String>?
        get() = javaResource.verbosity().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DiagnosticMapper : ResourceMapper<Diagnostic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.Diagnostic::class == javaResource::class

    override fun map(javaResource: Resource): Diagnostic = Diagnostic(
        javaResource as
            com.pulumi.azurenative.apimanagement.Diagnostic,
    )
}

/**
 * @see [Diagnostic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Diagnostic].
 */
public suspend fun diagnostic(name: String, block: suspend DiagnosticResourceBuilder.() -> Unit):
    Diagnostic {
    val builder = DiagnosticResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Diagnostic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diagnostic(name: String): Diagnostic {
    val builder = DiagnosticResourceBuilder()
    builder.name(name)
    return builder.build()
}
