@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.EmailTemplateArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.EmailTemplateParametersContractPropertiesArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.EmailTemplateParametersContractPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Email Template details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateTemplate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var emailTemplate = new AzureNative.ApiManagement.EmailTemplate("emailTemplate", new()
 *     {
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Subject = "Your request for $IssueName was successfully received.",
 *         TemplateName = "newIssueNotificationMessage",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewEmailTemplate(ctx, "emailTemplate", &apimanagement.EmailTemplateArgs{
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Subject:           pulumi.String("Your request for $IssueName was successfully received."),
 * 			TemplateName:      pulumi.String("newIssueNotificationMessage"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.EmailTemplate;
 * import com.pulumi.azurenative.apimanagement.EmailTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var emailTemplate = new EmailTemplate("emailTemplate", EmailTemplateArgs.builder()
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .subject("Your request for $IssueName was successfully received.")
 *             .templateName("newIssueNotificationMessage")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:EmailTemplate NewIssueNotificationMessage /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/templates/{templateName}
 * ```
 * @property body Email Template Body. This should be a valid XDocument
 * @property description Description of the Email Template.
 * @property parameters Email Template Parameter values.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property subject Subject of the Template.
 * @property templateName Email Template Name Identifier.
 * @property title Title of the Template.
 */
public data class EmailTemplateArgs(
    public val body: Output<String>? = null,
    public val description: Output<String>? = null,
    public val parameters: Output<List<EmailTemplateParametersContractPropertiesArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val subject: Output<String>? = null,
    public val templateName: Output<String>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.EmailTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.EmailTemplateArgs =
        com.pulumi.azurenative.apimanagement.EmailTemplateArgs.builder()
            .body(body?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .subject(subject?.applyValue({ args0 -> args0 }))
            .templateName(templateName?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailTemplateArgs].
 */
@PulumiTagMarker
public class EmailTemplateArgsBuilder internal constructor() {
    private var body: Output<String>? = null

    private var description: Output<String>? = null

    private var parameters: Output<List<EmailTemplateParametersContractPropertiesArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var subject: Output<String>? = null

    private var templateName: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Email Template Body. This should be a valid XDocument
     */
    @JvmName("lamotevsqytofbhm")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value Description of the Email Template.
     */
    @JvmName("ngnvaagnhqdmbfgf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Email Template Parameter values.
     */
    @JvmName("gptutaowdfssqaik")
    public suspend
    fun parameters(`value`: Output<List<EmailTemplateParametersContractPropertiesArgs>>) {
        this.parameters = value
    }

    @JvmName("ppaobingrarcbkbl")
    public suspend fun parameters(
        vararg
        values: Output<EmailTemplateParametersContractPropertiesArgs>,
    ) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Email Template Parameter values.
     */
    @JvmName("euecwgsvkxchisht")
    public suspend
    fun parameters(values: List<Output<EmailTemplateParametersContractPropertiesArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rnacqxrdypsmkcaw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("ysedqyblrbcmmwqa")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Subject of the Template.
     */
    @JvmName("hqvxcxdobynisxpd")
    public suspend fun subject(`value`: Output<String>) {
        this.subject = value
    }

    /**
     * @param value Email Template Name Identifier.
     */
    @JvmName("enbvdfpqlvugwolo")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value Title of the Template.
     */
    @JvmName("ihyroupfoakfkvqo")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Email Template Body. This should be a valid XDocument
     */
    @JvmName("ueaduvvyumsetytq")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value Description of the Email Template.
     */
    @JvmName("taeftajyatbyykit")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Email Template Parameter values.
     */
    @JvmName("xoeouqcsrwbimomr")
    public suspend fun parameters(`value`: List<EmailTemplateParametersContractPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Email Template Parameter values.
     */
    @JvmName("phpmevpyjfetmtys")
    public suspend
    fun parameters(argument: List<suspend EmailTemplateParametersContractPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EmailTemplateParametersContractPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Email Template Parameter values.
     */
    @JvmName("kxytdyjtrskmypgx")
    public suspend fun parameters(
        vararg
        argument: suspend EmailTemplateParametersContractPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EmailTemplateParametersContractPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Email Template Parameter values.
     */
    @JvmName("epvnrwwrolvmjems")
    public suspend
    fun parameters(argument: suspend EmailTemplateParametersContractPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EmailTemplateParametersContractPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Email Template Parameter values.
     */
    @JvmName("etekfytmqcgntjbm")
    public suspend fun parameters(vararg values: EmailTemplateParametersContractPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vgofojiyvqbxjyvc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("mbhoaifbgdyvnfnw")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Subject of the Template.
     */
    @JvmName("xeghappkbkgdlheu")
    public suspend fun subject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    /**
     * @param value Email Template Name Identifier.
     */
    @JvmName("ideebbvpcvtroahv")
    public suspend fun templateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    /**
     * @param value Title of the Template.
     */
    @JvmName("esjbloeripxufiif")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): EmailTemplateArgs = EmailTemplateArgs(
        body = body,
        description = description,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        subject = subject,
        templateName = templateName,
        title = title,
    )
}
