@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.GatewayArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ResourceLocationDataContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.ResourceLocationDataContractArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Gateway details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gateway = new AzureNative.ApiManagement.Gateway("gateway", new()
 *     {
 *         Description = "my gateway 1",
 *         GatewayId = "gw1",
 *         LocationData = new AzureNative.ApiManagement.Inputs.ResourceLocationDataContractArgs
 *         {
 *             Name = "my location",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGateway(ctx, "gateway", &apimanagement.GatewayArgs{
 * 			Description: pulumi.String("my gateway 1"),
 * 			GatewayId:   pulumi.String("gw1"),
 * 			LocationData: &apimanagement.ResourceLocationDataContractArgs{
 * 				Name: pulumi.String("my location"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Gateway;
 * import com.pulumi.azurenative.apimanagement.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gateway = new Gateway("gateway", GatewayArgs.builder()
 *             .description("my gateway 1")
 *             .gatewayId("gw1")
 *             .locationData(Map.of("name", "my location"))
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Gateway a1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/gateways/{gatewayId}
 * ```
 * @property description Gateway description
 * @property gatewayId Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
 * @property locationData Gateway location.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GatewayArgs(
    public val description: Output<String>? = null,
    public val gatewayId: Output<String>? = null,
    public val locationData: Output<ResourceLocationDataContractArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.GatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.GatewayArgs =
        com.pulumi.azurenative.apimanagement.GatewayArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .gatewayId(gatewayId?.applyValue({ args0 -> args0 }))
            .locationData(locationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var gatewayId: Output<String>? = null

    private var locationData: Output<ResourceLocationDataContractArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Gateway description
     */
    @JvmName("jmvgkbnjagjcpnve")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("dgicwkybhfhyumpc")
    public suspend fun gatewayId(`value`: Output<String>) {
        this.gatewayId = value
    }

    /**
     * @param value Gateway location.
     */
    @JvmName("ommfcqxwwjpklien")
    public suspend fun locationData(`value`: Output<ResourceLocationDataContractArgs>) {
        this.locationData = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rjxorrkgpufowvqj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("emwhcjjikrkfghoq")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Gateway description
     */
    @JvmName("jswldlhemyampuqt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gateway entity identifier. Must be unique in the current API Management service instance. Must not have value 'managed'
     */
    @JvmName("larhrhdemaejknkm")
    public suspend fun gatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayId = mapped
    }

    /**
     * @param value Gateway location.
     */
    @JvmName("kcgxawovavateifl")
    public suspend fun locationData(`value`: ResourceLocationDataContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationData = mapped
    }

    /**
     * @param argument Gateway location.
     */
    @JvmName("tdlhpnnreploqylt")
    public suspend
    fun locationData(argument: suspend ResourceLocationDataContractArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLocationDataContractArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.locationData = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qwqcujlembbouupv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("fcqrurklxsfspwuo")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        description = description,
        gatewayId = gatewayId,
        locationData = locationData,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
