@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GraphQLApiResolver].
 */
@PulumiTagMarker
public class GraphQLApiResolverResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GraphQLApiResolverArgs = GraphQLApiResolverArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GraphQLApiResolverArgsBuilder.() -> Unit) {
        val builder = GraphQLApiResolverArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GraphQLApiResolver {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.GraphQLApiResolver(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GraphQLApiResolver(builtJavaResource)
    }
}

/**
 * GraphQL API Resolver details.
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateGraphQLApiResolver
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var graphQLApiResolver = new AzureNative.ApiManagement.GraphQLApiResolver("graphQLApiResolver", new()
 *     {
 *         ApiId = "someAPI",
 *         Description = "A GraphQL Resolver example",
 *         DisplayName = "Query Users",
 *         Path = "Query/users",
 *         ResolverId = "newResolver",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewGraphQLApiResolver(ctx, "graphQLApiResolver", &apimanagement.GraphQLApiResolverArgs{
 * 			ApiId:             pulumi.String("someAPI"),
 * 			Description:       pulumi.String("A GraphQL Resolver example"),
 * 			DisplayName:       pulumi.String("Query Users"),
 * 			Path:              pulumi.String("Query/users"),
 * 			ResolverId:        pulumi.String("newResolver"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.GraphQLApiResolver;
 * import com.pulumi.azurenative.apimanagement.GraphQLApiResolverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var graphQLApiResolver = new GraphQLApiResolver("graphQLApiResolver", GraphQLApiResolverArgs.builder()
 *             .apiId("someAPI")
 *             .description("A GraphQL Resolver example")
 *             .displayName("Query Users")
 *             .path("Query/users")
 *             .resolverId("newResolver")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:GraphQLApiResolver newResolver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/apis/{apiId}/resolvers/{resolverId}
 * ```
 */
public class GraphQLApiResolver internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.GraphQLApiResolver,
) : KotlinCustomResource(javaResource, GraphQLApiResolverMapper) {
    /**
     * Description of the resolver. May include HTML formatting tags.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resolver Name.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Path is type/field being resolved.
     */
    public val path: Output<String>?
        get() = javaResource.path().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GraphQLApiResolverMapper : ResourceMapper<GraphQLApiResolver> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.GraphQLApiResolver::class == javaResource::class

    override fun map(javaResource: Resource): GraphQLApiResolver = GraphQLApiResolver(
        javaResource as
            com.pulumi.azurenative.apimanagement.GraphQLApiResolver,
    )
}

/**
 * @see [GraphQLApiResolver].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GraphQLApiResolver].
 */
public suspend fun graphQLApiResolver(
    name: String,
    block: suspend GraphQLApiResolverResourceBuilder.() -> Unit,
): GraphQLApiResolver {
    val builder = GraphQLApiResolverResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GraphQLApiResolver].
 * @param name The _unique_ name of the resulting resource.
 */
public fun graphQLApiResolver(name: String): GraphQLApiResolver {
    val builder = GraphQLApiResolverResourceBuilder()
    builder.name(name)
    return builder.build()
}
