@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Logger].
 */
@PulumiTagMarker
public class LoggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoggerArgs = LoggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoggerArgsBuilder.() -> Unit) {
        val builder = LoggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Logger {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.Logger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Logger(builtJavaResource)
    }
}

/**
 * Logger details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2017-03-01, 2018-01-01, 2019-12-01-preview, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateAILogger
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var logger = new AzureNative.ApiManagement.Logger("logger", new()
 *     {
 *         Credentials =
 *         {
 *             { "instrumentationKey", "11................a1" },
 *         },
 *         Description = "adding a new logger",
 *         LoggerId = "loggerId",
 *         LoggerType = "applicationInsights",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewLogger(ctx, "logger", &apimanagement.LoggerArgs{
 * 			Credentials: pulumi.StringMap{
 * 				"instrumentationKey": pulumi.String("11................a1"),
 * 			},
 * 			Description:       pulumi.String("adding a new logger"),
 * 			LoggerId:          pulumi.String("loggerId"),
 * 			LoggerType:        pulumi.String("applicationInsights"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Logger;
 * import com.pulumi.azurenative.apimanagement.LoggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logger = new Logger("logger", LoggerArgs.builder()
 *             .credentials(Map.of("instrumentationKey", "11................a1"))
 *             .description("adding a new logger")
 *             .loggerId("loggerId")
 *             .loggerType("applicationInsights")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateEHLogger
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var logger = new AzureNative.ApiManagement.Logger("logger", new()
 *     {
 *         Credentials =
 *         {
 *             { "connectionString", "Endpoint=sb://hydraeventhub-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=********=" },
 *             { "name", "hydraeventhub" },
 *         },
 *         Description = "adding a new logger",
 *         LoggerId = "eh1",
 *         LoggerType = "azureEventHub",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewLogger(ctx, "logger", &apimanagement.LoggerArgs{
 * 			Credentials: pulumi.StringMap{
 * 				"connectionString": pulumi.String("Endpoint=sb://hydraeventhub-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=********="),
 * 				"name":             pulumi.String("hydraeventhub"),
 * 			},
 * 			Description:       pulumi.String("adding a new logger"),
 * 			LoggerId:          pulumi.String("eh1"),
 * 			LoggerType:        pulumi.String("azureEventHub"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.Logger;
 * import com.pulumi.azurenative.apimanagement.LoggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var logger = new Logger("logger", LoggerArgs.builder()
 *             .credentials(Map.ofEntries(
 *                 Map.entry("connectionString", "Endpoint=sb://hydraeventhub-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=********="),
 *                 Map.entry("name", "hydraeventhub")
 *             ))
 *             .description("adding a new logger")
 *             .loggerId("eh1")
 *             .loggerType("azureEventHub")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:Logger eh1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/loggers/{loggerId}
 * ```
 */
public class Logger internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.Logger,
) : KotlinCustomResource(javaResource, LoggerMapper) {
    /**
     * The name and SendRule connection string of the event hub for azureEventHub logger.
     * Instrumentation key for applicationInsights logger.
     */
    public val credentials: Output<Map<String, String>>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Logger description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether records are buffered in the logger before publishing. Default is assumed to be true.
     */
    public val isBuffered: Output<Boolean>?
        get() = javaResource.isBuffered().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Logger type.
     */
    public val loggerType: Output<String>
        get() = javaResource.loggerType().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Id of a log target (either Azure Event Hub resource or Azure Application Insights resource).
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LoggerMapper : ResourceMapper<Logger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.Logger::class == javaResource::class

    override fun map(javaResource: Resource): Logger = Logger(
        javaResource as
            com.pulumi.azurenative.apimanagement.Logger,
    )
}

/**
 * @see [Logger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Logger].
 */
public suspend fun logger(name: String, block: suspend LoggerResourceBuilder.() -> Unit): Logger {
    val builder = LoggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Logger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logger(name: String): Logger {
    val builder = LoggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
