@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OpenIdConnectProvider].
 */
@PulumiTagMarker
public class OpenIdConnectProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OpenIdConnectProviderArgs = OpenIdConnectProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OpenIdConnectProviderArgsBuilder.() -> Unit) {
        val builder = OpenIdConnectProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OpenIdConnectProvider {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.OpenIdConnectProvider(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OpenIdConnectProvider(builtJavaResource)
    }
}

/**
 * OpenId Connect Provider details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-07-07, 2016-10-10, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateOpenIdConnectProvider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var openIdConnectProvider = new AzureNative.ApiManagement.OpenIdConnectProvider("openIdConnectProvider", new()
 *     {
 *         ClientId = "oidprovidertemplate3",
 *         ClientSecret = "x",
 *         DisplayName = "templateoidprovider3",
 *         MetadataEndpoint = "https://oidprovider-template3.net",
 *         Opid = "templateOpenIdConnect3",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         UseInApiDocumentation = true,
 *         UseInTestConsole = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewOpenIdConnectProvider(ctx, "openIdConnectProvider", &apimanagement.OpenIdConnectProviderArgs{
 * 			ClientId:              pulumi.String("oidprovidertemplate3"),
 * 			ClientSecret:          pulumi.String("x"),
 * 			DisplayName:           pulumi.String("templateoidprovider3"),
 * 			MetadataEndpoint:      pulumi.String("https://oidprovider-template3.net"),
 * 			Opid:                  pulumi.String("templateOpenIdConnect3"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			ServiceName:           pulumi.String("apimService1"),
 * 			UseInApiDocumentation: pulumi.Bool(true),
 * 			UseInTestConsole:      pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.OpenIdConnectProvider;
 * import com.pulumi.azurenative.apimanagement.OpenIdConnectProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var openIdConnectProvider = new OpenIdConnectProvider("openIdConnectProvider", OpenIdConnectProviderArgs.builder()
 *             .clientId("oidprovidertemplate3")
 *             .clientSecret("x")
 *             .displayName("templateoidprovider3")
 *             .metadataEndpoint("https://oidprovider-template3.net")
 *             .opid("templateOpenIdConnect3")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .useInApiDocumentation(true)
 *             .useInTestConsole(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:OpenIdConnectProvider templateOpenIdConnect3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/openidConnectProviders/{opid}
 * ```
 */
public class OpenIdConnectProvider internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.OpenIdConnectProvider,
) : KotlinCustomResource(javaResource, OpenIdConnectProviderMapper) {
    /**
     * Client ID of developer console which is the client application.
     */
    public val clientId: Output<String>
        get() = javaResource.clientId().applyValue({ args0 -> args0 })

    /**
     * Client Secret of developer console which is the client application.
     */
    public val clientSecret: Output<String>?
        get() = javaResource.clientSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-friendly description of OpenID Connect Provider.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-friendly OpenID Connect Provider name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Metadata endpoint URI.
     */
    public val metadataEndpoint: Output<String>
        get() = javaResource.metadataEndpoint().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by default if no value is provided.
     */
    public val useInApiDocumentation: Output<Boolean>?
        get() = javaResource.useInApiDocumentation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no value is provided.
     */
    public val useInTestConsole: Output<Boolean>?
        get() = javaResource.useInTestConsole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object OpenIdConnectProviderMapper : ResourceMapper<OpenIdConnectProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.OpenIdConnectProvider::class == javaResource::class

    override fun map(javaResource: Resource): OpenIdConnectProvider =
        OpenIdConnectProvider(
            javaResource as
                com.pulumi.azurenative.apimanagement.OpenIdConnectProvider,
        )
}

/**
 * @see [OpenIdConnectProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OpenIdConnectProvider].
 */
public suspend fun openIdConnectProvider(
    name: String,
    block: suspend OpenIdConnectProviderResourceBuilder.() -> Unit,
): OpenIdConnectProvider {
    val builder = OpenIdConnectProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OpenIdConnectProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun openIdConnectProvider(name: String): OpenIdConnectProvider {
    val builder = OpenIdConnectProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
