@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiContactInformationResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiLicenseInformationResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiVersionSetContractDetailsResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthenticationSettingsContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.SubscriptionKeyParameterNamesContractResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiContactInformationResponse.Companion.toKotlin as apiContactInformationResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiLicenseInformationResponse.Companion.toKotlin as apiLicenseInformationResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiVersionSetContractDetailsResponse.Companion.toKotlin as apiVersionSetContractDetailsResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthenticationSettingsContractResponse.Companion.toKotlin as authenticationSettingsContractResponseToKotlin
import com.pulumi.azurenative.apimanagement.kotlin.outputs.SubscriptionKeyParameterNamesContractResponse.Companion.toKotlin as subscriptionKeyParameterNamesContractResponseToKotlin

/**
 * Builder for [ProductApi].
 */
@PulumiTagMarker
public class ProductApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductApiArgs = ProductApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductApiArgsBuilder.() -> Unit) {
        val builder = ProductApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProductApi {
        val builtJavaResource = com.pulumi.azurenative.apimanagement.ProductApi(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProductApi(builtJavaResource)
    }
}

/**
 * API details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2017-03-01, 2018-06-01-preview, 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProductApi
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var productApi = new AzureNative.ApiManagement.ProductApi("productApi", new()
 *     {
 *         ApiId = "echo-api",
 *         ProductId = "testproduct",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewProductApi(ctx, "productApi", &apimanagement.ProductApiArgs{
 * 			ApiId:             pulumi.String("echo-api"),
 * 			ProductId:         pulumi.String("testproduct"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ProductApi;
 * import com.pulumi.azurenative.apimanagement.ProductApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var productApi = new ProductApi("productApi", ProductApiArgs.builder()
 *             .apiId("echo-api")
 *             .productId("testproduct")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ProductApi 5931a75ae4bbd512a88c680b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/apis/{apiId}
 * ```
 */
public class ProductApi internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ProductApi,
) : KotlinCustomResource(javaResource, ProductApiMapper) {
    /**
     * Describes the revision of the API. If no value is provided, default revision 1 is created
     */
    public val apiRevision: Output<String>?
        get() = javaResource.apiRevision().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the API Revision.
     */
    public val apiRevisionDescription: Output<String>?
        get() = javaResource.apiRevisionDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of API.
     */
    public val apiType: Output<String>?
        get() = javaResource.apiType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates the version identifier of the API if the API is versioned
     */
    public val apiVersion: Output<String>?
        get() = javaResource.apiVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the API Version.
     */
    public val apiVersionDescription: Output<String>?
        get() = javaResource.apiVersionDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Version set details
     */
    public val apiVersionSet: Output<ApiVersionSetContractDetailsResponse>?
        get() = javaResource.apiVersionSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> apiVersionSetContractDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A resource identifier for the related ApiVersionSet.
     */
    public val apiVersionSetId: Output<String>?
        get() = javaResource.apiVersionSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Collection of authentication settings included into this API.
     */
    public val authenticationSettings: Output<AuthenticationSettingsContractResponse>?
        get() = javaResource.authenticationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> authenticationSettingsContractResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Contact information for the API.
     */
    public val contact: Output<ApiContactInformationResponse>?
        get() = javaResource.contact().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    apiContactInformationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Description of the API. May include HTML formatting tags.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * API name. Must be 1 to 300 characters long.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if API revision is current api revision.
     */
    public val isCurrent: Output<Boolean>?
        get() = javaResource.isCurrent().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates if API revision is accessible via the gateway.
     */
    public val isOnline: Output<Boolean>
        get() = javaResource.isOnline().applyValue({ args0 -> args0 })

    /**
     * License information for the API.
     */
    public val license: Output<ApiLicenseInformationResponse>?
        get() = javaResource.license().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    apiLicenseInformationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Relative URL uniquely identifying this API and all of its resource paths within the API Management service instance. It is appended to the API endpoint base URL specified during the service instance creation to form a public URL for this API.
     */
    public val path: Output<String>
        get() = javaResource.path().applyValue({ args0 -> args0 })

    /**
     * Describes on which protocols the operations in this API can be invoked.
     */
    public val protocols: Output<List<String>>?
        get() = javaResource.protocols().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Absolute URL of the backend service implementing this API. Cannot be more than 2000 characters long.
     */
    public val serviceUrl: Output<String>?
        get() = javaResource.serviceUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * API identifier of the source API.
     */
    public val sourceApiId: Output<String>?
        get() = javaResource.sourceApiId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Protocols over which API is made available.
     */
    public val subscriptionKeyParameterNames: Output<SubscriptionKeyParameterNamesContractResponse>?
        get() = javaResource.subscriptionKeyParameterNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subscriptionKeyParameterNamesContractResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies whether an API or Product subscription is required for accessing the API.
     */
    public val subscriptionRequired: Output<Boolean>?
        get() = javaResource.subscriptionRequired().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     *  A URL to the Terms of Service for the API. MUST be in the format of a URL.
     */
    public val termsOfServiceUrl: Output<String>?
        get() = javaResource.termsOfServiceUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProductApiMapper : ResourceMapper<ProductApi> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ProductApi::class == javaResource::class

    override fun map(javaResource: Resource): ProductApi = ProductApi(
        javaResource as
            com.pulumi.azurenative.apimanagement.ProductApi,
    )
}

/**
 * @see [ProductApi].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProductApi].
 */
public suspend fun productApi(name: String, block: suspend ProductApiResourceBuilder.() -> Unit):
    ProductApi {
    val builder = ProductApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProductApi].
 * @param name The _unique_ name of the resulting resource.
 */
public fun productApi(name: String): ProductApi {
    val builder = ProductApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
