@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ProductApiLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Product-API link details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProductApiLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var productApiLink = new AzureNative.ApiManagement.ProductApiLink("productApiLink", new()
 *     {
 *         ApiId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api",
 *         ApiLinkId = "link1",
 *         ProductId = "testproduct",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewProductApiLink(ctx, "productApiLink", &apimanagement.ProductApiLinkArgs{
 * 			ApiId:             pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api"),
 * 			ApiLinkId:         pulumi.String("link1"),
 * 			ProductId:         pulumi.String("testproduct"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ProductApiLink;
 * import com.pulumi.azurenative.apimanagement.ProductApiLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var productApiLink = new ProductApiLink("productApiLink", ProductApiLinkArgs.builder()
 *             .apiId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api")
 *             .apiLinkId("link1")
 *             .productId("testproduct")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ProductApiLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/apiLinks/{apiLinkId}
 * ```
 * @property apiId Full resource Id of an API.
 * @property apiLinkId Product-API link identifier. Must be unique in the current API Management service instance.
 * @property productId Product identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class ProductApiLinkArgs(
    public val apiId: Output<String>? = null,
    public val apiLinkId: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ProductApiLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ProductApiLinkArgs =
        com.pulumi.azurenative.apimanagement.ProductApiLinkArgs.builder()
            .apiId(apiId?.applyValue({ args0 -> args0 }))
            .apiLinkId(apiLinkId?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductApiLinkArgs].
 */
@PulumiTagMarker
public class ProductApiLinkArgsBuilder internal constructor() {
    private var apiId: Output<String>? = null

    private var apiLinkId: Output<String>? = null

    private var productId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Full resource Id of an API.
     */
    @JvmName("rfevgbkaqhjbtbtg")
    public suspend fun apiId(`value`: Output<String>) {
        this.apiId = value
    }

    /**
     * @param value Product-API link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("gnskjesmrumaabmx")
    public suspend fun apiLinkId(`value`: Output<String>) {
        this.apiLinkId = value
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("rwjptdksngkbdptu")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vlfxcqmitifldbec")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("vgqidmmbhveeobiv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Full resource Id of an API.
     */
    @JvmName("mymthdanjhjvkydk")
    public suspend fun apiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiId = mapped
    }

    /**
     * @param value Product-API link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("cjlwwxeyutssmtwh")
    public suspend fun apiLinkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiLinkId = mapped
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("awsoakngybiraytq")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jjenqpackvuhvevi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jpkstewlrpdumbjc")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ProductApiLinkArgs = ProductApiLinkArgs(
        apiId = apiId,
        apiLinkId = apiLinkId,
        productId = productId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
