@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProductGroupLink].
 */
@PulumiTagMarker
public class ProductGroupLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductGroupLinkArgs = ProductGroupLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductGroupLinkArgsBuilder.() -> Unit) {
        val builder = ProductGroupLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProductGroupLink {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ProductGroupLink(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProductGroupLink(builtJavaResource)
    }
}

/**
 * Product-group link details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProductGroupLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var productGroupLink = new AzureNative.ApiManagement.ProductGroupLink("productGroupLink", new()
 *     {
 *         GroupId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/groups/group1",
 *         GroupLinkId = "link1",
 *         ProductId = "testproduct",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewProductGroupLink(ctx, "productGroupLink", &apimanagement.ProductGroupLinkArgs{
 * 			GroupId:           pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/groups/group1"),
 * 			GroupLinkId:       pulumi.String("link1"),
 * 			ProductId:         pulumi.String("testproduct"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ProductGroupLink;
 * import com.pulumi.azurenative.apimanagement.ProductGroupLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var productGroupLink = new ProductGroupLink("productGroupLink", ProductGroupLinkArgs.builder()
 *             .groupId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/groups/group1")
 *             .groupLinkId("link1")
 *             .productId("testproduct")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ProductGroupLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/groupLinks/{groupLinkId}
 * ```
 */
public class ProductGroupLink internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ProductGroupLink,
) : KotlinCustomResource(javaResource, ProductGroupLinkMapper) {
    /**
     * Full resource Id of a group.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProductGroupLinkMapper : ResourceMapper<ProductGroupLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ProductGroupLink::class == javaResource::class

    override fun map(javaResource: Resource): ProductGroupLink = ProductGroupLink(
        javaResource as
            com.pulumi.azurenative.apimanagement.ProductGroupLink,
    )
}

/**
 * @see [ProductGroupLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProductGroupLink].
 */
public suspend fun productGroupLink(
    name: String,
    block: suspend ProductGroupLinkResourceBuilder.() -> Unit,
): ProductGroupLink {
    val builder = ProductGroupLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProductGroupLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun productGroupLink(name: String): ProductGroupLink {
    val builder = ProductGroupLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
