@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.kotlin.outputs.WikiDocumentationContractResponse
import com.pulumi.azurenative.apimanagement.kotlin.outputs.WikiDocumentationContractResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ProductWiki].
 */
@PulumiTagMarker
public class ProductWikiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductWikiArgs = ProductWikiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductWikiArgsBuilder.() -> Unit) {
        val builder = ProductWikiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProductWiki {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.ProductWiki(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProductWiki(builtJavaResource)
    }
}

/**
 * Wiki properties
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProductWiki
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var productWiki = new AzureNative.ApiManagement.ProductWiki("productWiki", new()
 *     {
 *         Documents = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.WikiDocumentationContractArgs
 *             {
 *                 DocumentationId = "docId1",
 *             },
 *             new AzureNative.ApiManagement.Inputs.WikiDocumentationContractArgs
 *             {
 *                 DocumentationId = "docId2",
 *             },
 *         },
 *         ProductId = "57d1f7558aa04f15146d9d8a",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewProductWiki(ctx, "productWiki", &apimanagement.ProductWikiArgs{
 * 			Documents: []apimanagement.WikiDocumentationContractArgs{
 * 				{
 * 					DocumentationId: pulumi.String("docId1"),
 * 				},
 * 				{
 * 					DocumentationId: pulumi.String("docId2"),
 * 				},
 * 			},
 * 			ProductId:         pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ProductWiki;
 * import com.pulumi.azurenative.apimanagement.ProductWikiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var productWiki = new ProductWiki("productWiki", ProductWikiArgs.builder()
 *             .documents(
 *                 Map.of("documentationId", "docId1"),
 *                 Map.of("documentationId", "docId2"))
 *             .productId("57d1f7558aa04f15146d9d8a")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ProductWiki default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/wikis/default
 * ```
 */
public class ProductWiki internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.ProductWiki,
) : KotlinCustomResource(javaResource, ProductWikiMapper) {
    /**
     * Collection wiki documents included into this wiki.
     */
    public val documents: Output<List<WikiDocumentationContractResponse>>?
        get() = javaResource.documents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProductWikiMapper : ResourceMapper<ProductWiki> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.ProductWiki::class == javaResource::class

    override fun map(javaResource: Resource): ProductWiki = ProductWiki(
        javaResource as
            com.pulumi.azurenative.apimanagement.ProductWiki,
    )
}

/**
 * @see [ProductWiki].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProductWiki].
 */
public suspend fun productWiki(name: String, block: suspend ProductWikiResourceBuilder.() -> Unit):
    ProductWiki {
    val builder = ProductWikiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProductWiki].
 * @param name The _unique_ name of the resulting resource.
 */
public fun productWiki(name: String): ProductWiki {
    val builder = ProductWikiResourceBuilder()
    builder.name(name)
    return builder.build()
}
