@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.ProductWikiArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.inputs.WikiDocumentationContractArgs
import com.pulumi.azurenative.apimanagement.kotlin.inputs.WikiDocumentationContractArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Wiki properties
 * Azure REST API version: 2022-08-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProductWiki
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var productWiki = new AzureNative.ApiManagement.ProductWiki("productWiki", new()
 *     {
 *         Documents = new[]
 *         {
 *             new AzureNative.ApiManagement.Inputs.WikiDocumentationContractArgs
 *             {
 *                 DocumentationId = "docId1",
 *             },
 *             new AzureNative.ApiManagement.Inputs.WikiDocumentationContractArgs
 *             {
 *                 DocumentationId = "docId2",
 *             },
 *         },
 *         ProductId = "57d1f7558aa04f15146d9d8a",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewProductWiki(ctx, "productWiki", &apimanagement.ProductWikiArgs{
 * 			Documents: []apimanagement.WikiDocumentationContractArgs{
 * 				{
 * 					DocumentationId: pulumi.String("docId1"),
 * 				},
 * 				{
 * 					DocumentationId: pulumi.String("docId2"),
 * 				},
 * 			},
 * 			ProductId:         pulumi.String("57d1f7558aa04f15146d9d8a"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.ProductWiki;
 * import com.pulumi.azurenative.apimanagement.ProductWikiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var productWiki = new ProductWiki("productWiki", ProductWikiArgs.builder()
 *             .documents(
 *                 Map.of("documentationId", "docId1"),
 *                 Map.of("documentationId", "docId2"))
 *             .productId("57d1f7558aa04f15146d9d8a")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:ProductWiki default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/wikis/default
 * ```
 * @property documents Collection wiki documents included into this wiki.
 * @property productId Product identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class ProductWikiArgs(
    public val documents: Output<List<WikiDocumentationContractArgs>>? = null,
    public val productId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.ProductWikiArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.ProductWikiArgs =
        com.pulumi.azurenative.apimanagement.ProductWikiArgs.builder()
            .documents(
                documents?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .productId(productId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductWikiArgs].
 */
@PulumiTagMarker
public class ProductWikiArgsBuilder internal constructor() {
    private var documents: Output<List<WikiDocumentationContractArgs>>? = null

    private var productId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value Collection wiki documents included into this wiki.
     */
    @JvmName("obdcdlydbniywuad")
    public suspend fun documents(`value`: Output<List<WikiDocumentationContractArgs>>) {
        this.documents = value
    }

    @JvmName("barvtvfxpjcvmwbu")
    public suspend fun documents(vararg values: Output<WikiDocumentationContractArgs>) {
        this.documents = Output.all(values.asList())
    }

    /**
     * @param values Collection wiki documents included into this wiki.
     */
    @JvmName("hycthyjxgagwpqgo")
    public suspend fun documents(values: List<Output<WikiDocumentationContractArgs>>) {
        this.documents = Output.all(values)
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("jsavtigthxksygwq")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pnnuvcqltqawckwm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("kywcnpeneyaejjsa")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Collection wiki documents included into this wiki.
     */
    @JvmName("vlgcvbvdxsqyoexx")
    public suspend fun documents(`value`: List<WikiDocumentationContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documents = mapped
    }

    /**
     * @param argument Collection wiki documents included into this wiki.
     */
    @JvmName("nvwdchmyygnyrhdq")
    public suspend
    fun documents(argument: List<suspend WikiDocumentationContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WikiDocumentationContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.documents = mapped
    }

    /**
     * @param argument Collection wiki documents included into this wiki.
     */
    @JvmName("qvaidcbgvgygvwix")
    public suspend fun documents(
        vararg
        argument: suspend WikiDocumentationContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WikiDocumentationContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.documents = mapped
    }

    /**
     * @param argument Collection wiki documents included into this wiki.
     */
    @JvmName("qwsocnlkouxjrgrq")
    public suspend fun documents(argument: suspend WikiDocumentationContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WikiDocumentationContractArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.documents = mapped
    }

    /**
     * @param values Collection wiki documents included into this wiki.
     */
    @JvmName("mvtifdffefvhkvny")
    public suspend fun documents(vararg values: WikiDocumentationContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.documents = mapped
    }

    /**
     * @param value Product identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("swwvqvewhomnlsdu")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("idaqdqoemdxsetkj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jhfshsetxpuwnxfj")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ProductWikiArgs = ProductWikiArgs(
        documents = documents,
        productId = productId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
