@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TagByProduct].
 */
@PulumiTagMarker
public class TagByProductResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagByProductArgs = TagByProductArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagByProductArgsBuilder.() -> Unit) {
        val builder = TagByProductArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TagByProduct {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.TagByProduct(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TagByProduct(builtJavaResource)
    }
}

/**
 * Tag Contract details.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateProductTag
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagByProduct = new AzureNative.ApiManagement.TagByProduct("tagByProduct", new()
 *     {
 *         ProductId = "5931a75ae4bbd512a88c680b",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagId = "tagId1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewTagByProduct(ctx, "tagByProduct", &apimanagement.TagByProductArgs{
 * 			ProductId:         pulumi.String("5931a75ae4bbd512a88c680b"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			TagId:             pulumi.String("tagId1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.TagByProduct;
 * import com.pulumi.azurenative.apimanagement.TagByProductArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagByProduct = new TagByProduct("tagByProduct", TagByProductArgs.builder()
 *             .productId("5931a75ae4bbd512a88c680b")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagId("tagId1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:TagByProduct tagId1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/products/{productId}/tags/{tagId}
 * ```
 */
public class TagByProduct internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.TagByProduct,
) : KotlinCustomResource(javaResource, TagByProductMapper) {
    /**
     * Tag name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TagByProductMapper : ResourceMapper<TagByProduct> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.TagByProduct::class == javaResource::class

    override fun map(javaResource: Resource): TagByProduct = TagByProduct(
        javaResource as
            com.pulumi.azurenative.apimanagement.TagByProduct,
    )
}

/**
 * @see [TagByProduct].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagByProduct].
 */
public suspend fun tagByProduct(
    name: String,
    block: suspend TagByProductResourceBuilder.() -> Unit,
): TagByProduct {
    val builder = TagByProductResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagByProduct].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagByProduct(name: String): TagByProduct {
    val builder = TagByProductResourceBuilder()
    builder.name(name)
    return builder.build()
}
