@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.TagProductLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Tag-product link details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateTagProductLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagProductLink = new AzureNative.ApiManagement.TagProductLink("tagProductLink", new()
 *     {
 *         ProductId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/products/product1",
 *         ProductLinkId = "link1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         TagId = "tag1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewTagProductLink(ctx, "tagProductLink", &apimanagement.TagProductLinkArgs{
 * 			ProductId:         pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/products/product1"),
 * 			ProductLinkId:     pulumi.String("link1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			TagId:             pulumi.String("tag1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.TagProductLink;
 * import com.pulumi.azurenative.apimanagement.TagProductLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagProductLink = new TagProductLink("tagProductLink", TagProductLinkArgs.builder()
 *             .productId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/products/product1")
 *             .productLinkId("link1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .tagId("tag1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:TagProductLink link1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/tags/{tagId}/productLinks/{productLinkId}
 * ```
 * @property productId Full resource Id of a product.
 * @property productLinkId Tag-product link identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 * @property tagId Tag identifier. Must be unique in the current API Management service instance.
 */
public data class TagProductLinkArgs(
    public val productId: Output<String>? = null,
    public val productLinkId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tagId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.TagProductLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.TagProductLinkArgs =
        com.pulumi.azurenative.apimanagement.TagProductLinkArgs.builder()
            .productId(productId?.applyValue({ args0 -> args0 }))
            .productLinkId(productLinkId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tagId(tagId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagProductLinkArgs].
 */
@PulumiTagMarker
public class TagProductLinkArgsBuilder internal constructor() {
    private var productId: Output<String>? = null

    private var productLinkId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tagId: Output<String>? = null

    /**
     * @param value Full resource Id of a product.
     */
    @JvmName("imtrrdxfmgghhnda")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value Tag-product link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("ugwebqthaiktxfgx")
    public suspend fun productLinkId(`value`: Output<String>) {
        this.productLinkId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("imailwforkepymgx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("igigwtfnhbllhdgq")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("xokdgsblbfnxqotc")
    public suspend fun tagId(`value`: Output<String>) {
        this.tagId = value
    }

    /**
     * @param value Full resource Id of a product.
     */
    @JvmName("uqkcocutxigmmjph")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value Tag-product link identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("akvlfjdlgtttncuj")
    public suspend fun productLinkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productLinkId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bmwjdpujprsriqsm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("dtwynwxqcoaeunvq")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Tag identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("sjqfudrnriuashac")
    public suspend fun tagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagId = mapped
    }

    internal fun build(): TagProductLinkArgs = TagProductLinkArgs(
        productId = productId,
        productLinkId = productLinkId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tagId = tagId,
    )
}
