@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.azurenative.apimanagement.WorkspaceGlobalSchemaArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.SchemaType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Global Schema Contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceSchema
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceGlobalSchema = new AzureNative.ApiManagement.WorkspaceGlobalSchema("workspaceGlobalSchema", new()
 *     {
 *         Description = "sample schema description",
 *         ResourceGroupName = "rg1",
 *         SchemaId = "schema1",
 *         SchemaType = "xml",
 *         ServiceName = "apimService1",
 *         Value = @"<xsd:schema xmlns:xsd=""http://www.w3.org/2001/XMLSchema""
 *            xmlns:tns=""http://tempuri.org/PurchaseOrderSchema.xsd""
 *            targetNamespace=""http://tempuri.org/PurchaseOrderSchema.xsd""
 *            elementFormDefault=""qualified"">
 *  <xsd:element name=""PurchaseOrder"" type=""tns:PurchaseOrderType""/>
 *  <xsd:complexType name=""PurchaseOrderType"">
 *   <xsd:sequence>
 *    <xsd:element name=""ShipTo"" type=""tns:USAddress"" maxOccurs=""2""/>
 *    <xsd:element name=""BillTo"" type=""tns:USAddress""/>
 *   </xsd:sequence>
 *   <xsd:attribute name=""OrderDate"" type=""xsd:date""/>
 *  </xsd:complexType>
 *  <xsd:complexType name=""USAddress"">
 *   <xsd:sequence>
 *    <xsd:element name=""name""   type=""xsd:string""/>
 *    <xsd:element name=""street"" type=""xsd:string""/>
 *    <xsd:element name=""city""   type=""xsd:string""/>
 *    <xsd:element name=""state""  type=""xsd:string""/>
 *    <xsd:element name=""zip""    type=""xsd:integer""/>
 *   </xsd:sequence>
 *   <xsd:attribute name=""country"" type=""xsd:NMTOKEN"" fixed=""US""/>
 *  </xsd:complexType>
 * </xsd:schema>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceGlobalSchema(ctx, "workspaceGlobalSchema", &apimanagement.WorkspaceGlobalSchemaArgs{
 * 			Description:       pulumi.String("sample schema description"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SchemaId:          pulumi.String("schema1"),
 * 			SchemaType:        pulumi.String("xml"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value: pulumi.Any(`<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
 *            xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            elementFormDefault="qualified">
 *  <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>
 *  <xsd:complexType name="PurchaseOrderType">
 *   <xsd:sequence>
 *    <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>
 *    <xsd:element name="BillTo" type="tns:USAddress"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="OrderDate" type="xsd:date"/>
 *  </xsd:complexType>
 *  <xsd:complexType name="USAddress">
 *   <xsd:sequence>
 *    <xsd:element name="name"   type="xsd:string"/>
 *    <xsd:element name="street" type="xsd:string"/>
 *    <xsd:element name="city"   type="xsd:string"/>
 *    <xsd:element name="state"  type="xsd:string"/>
 *    <xsd:element name="zip"    type="xsd:integer"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>
 *  </xsd:complexType>
 * </xsd:schema>`),
 * 			WorkspaceId: pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGlobalSchema;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGlobalSchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceGlobalSchema = new WorkspaceGlobalSchema("workspaceGlobalSchema", WorkspaceGlobalSchemaArgs.builder()
 *             .description("sample schema description")
 *             .resourceGroupName("rg1")
 *             .schemaId("schema1")
 *             .schemaType("xml")
 *             .serviceName("apimService1")
 *             .value("""
 * <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"
 *            xmlns:tns="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            targetNamespace="http://tempuri.org/PurchaseOrderSchema.xsd"
 *            elementFormDefault="qualified">
 *  <xsd:element name="PurchaseOrder" type="tns:PurchaseOrderType"/>
 *  <xsd:complexType name="PurchaseOrderType">
 *   <xsd:sequence>
 *    <xsd:element name="ShipTo" type="tns:USAddress" maxOccurs="2"/>
 *    <xsd:element name="BillTo" type="tns:USAddress"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="OrderDate" type="xsd:date"/>
 *  </xsd:complexType>
 *  <xsd:complexType name="USAddress">
 *   <xsd:sequence>
 *    <xsd:element name="name"   type="xsd:string"/>
 *    <xsd:element name="street" type="xsd:string"/>
 *    <xsd:element name="city"   type="xsd:string"/>
 *    <xsd:element name="state"  type="xsd:string"/>
 *    <xsd:element name="zip"    type="xsd:integer"/>
 *   </xsd:sequence>
 *   <xsd:attribute name="country" type="xsd:NMTOKEN" fixed="US"/>
 *  </xsd:complexType>
 * </xsd:schema>            """)
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceGlobalSchema schema1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/schemas/{schemaId}
 * ```
 * @property description Free-form schema entity description.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schemaId Schema id identifier. Must be unique in the current API Management service instance.
 * @property schemaType Schema Type. Immutable.
 * @property serviceName The name of the API Management service.
 * @property value Json-encoded string for non json-based schema.
 * @property workspaceId Workspace identifier. Must be unique in the current API Management service instance.
 */
public data class WorkspaceGlobalSchemaArgs(
    public val description: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schemaId: Output<String>? = null,
    public val schemaType: Output<Either<String, SchemaType>>? = null,
    public val serviceName: Output<String>? = null,
    public val `value`: Output<Any>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.WorkspaceGlobalSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.WorkspaceGlobalSchemaArgs =
        com.pulumi.azurenative.apimanagement.WorkspaceGlobalSchemaArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schemaId(schemaId?.applyValue({ args0 -> args0 }))
            .schemaType(
                schemaType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceGlobalSchemaArgs].
 */
@PulumiTagMarker
public class WorkspaceGlobalSchemaArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schemaId: Output<String>? = null

    private var schemaType: Output<Either<String, SchemaType>>? = null

    private var serviceName: Output<String>? = null

    private var `value`: Output<Any>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value Free-form schema entity description.
     */
    @JvmName("qsptiajvvfgdpepk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dilejvpemvkbogkm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("cuuannablcabdnss")
    public suspend fun schemaId(`value`: Output<String>) {
        this.schemaId = value
    }

    /**
     * @param value Schema Type. Immutable.
     */
    @JvmName("kaulbbxgwhmiuwvp")
    public suspend fun schemaType(`value`: Output<Either<String, SchemaType>>) {
        this.schemaType = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("wfshuewrhrtgwrab")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Json-encoded string for non json-based schema.
     */
    @JvmName("umpardgnhdryhoil")
    public suspend fun `value`(`value`: Output<Any>) {
        this.`value` = value
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("atofvwepwkxplukw")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Free-form schema entity description.
     */
    @JvmName("bavyglkxwmgucawf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wetosthagylmodql")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("gmupuxclqsyetfvo")
    public suspend fun schemaId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaId = mapped
    }

    /**
     * @param value Schema Type. Immutable.
     */
    @JvmName("pfpgfaqmxwewxpfj")
    public suspend fun schemaType(`value`: Either<String, SchemaType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value Schema Type. Immutable.
     */
    @JvmName("dfvqjmucmghfpxkq")
    public fun schemaType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value Schema Type. Immutable.
     */
    @JvmName("mphevfobcjlxgjxw")
    public fun schemaType(`value`: SchemaType) {
        val toBeMapped = Either.ofRight<String, SchemaType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaType = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("qvcqsvsochmnjilt")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Json-encoded string for non json-based schema.
     */
    @JvmName("ncrsvcymglewucya")
    public suspend fun `value`(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value Workspace identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("lqikwdttglokoagp")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): WorkspaceGlobalSchemaArgs = WorkspaceGlobalSchemaArgs(
        description = description,
        resourceGroupName = resourceGroupName,
        schemaId = schemaId,
        schemaType = schemaType,
        serviceName = serviceName,
        `value` = `value`,
        workspaceId = workspaceId,
    )
}
