@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceGroup].
 */
@PulumiTagMarker
public class WorkspaceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceGroupArgs = WorkspaceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceGroupArgsBuilder.() -> Unit) {
        val builder = WorkspaceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspaceGroup {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspaceGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceGroup(builtJavaResource)
    }
}

/**
 * Contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceGroup = new AzureNative.ApiManagement.WorkspaceGroup("workspaceGroup", new()
 *     {
 *         DisplayName = "temp group",
 *         GroupId = "tempgroup",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceGroup(ctx, "workspaceGroup", &apimanagement.WorkspaceGroupArgs{
 * 			DisplayName:       pulumi.String("temp group"),
 * 			GroupId:           pulumi.String("tempgroup"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroup;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceGroup = new WorkspaceGroup("workspaceGroup", WorkspaceGroupArgs.builder()
 *             .displayName("temp group")
 *             .groupId("tempgroup")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ### ApiManagementCreateWorkspaceGroupExternal
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceGroup = new AzureNative.ApiManagement.WorkspaceGroup("workspaceGroup", new()
 *     {
 *         Description = "new group to test",
 *         DisplayName = "NewGroup (samiraad.onmicrosoft.com)",
 *         ExternalId = "aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d",
 *         GroupId = "aadGroup",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Type = AzureNative.ApiManagement.GroupType.External,
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceGroup(ctx, "workspaceGroup", &apimanagement.WorkspaceGroupArgs{
 * 			Description:       pulumi.String("new group to test"),
 * 			DisplayName:       pulumi.String("NewGroup (samiraad.onmicrosoft.com)"),
 * 			ExternalId:        pulumi.String("aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d"),
 * 			GroupId:           pulumi.String("aadGroup"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Type:              apimanagement.GroupTypeExternal,
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroup;
 * import com.pulumi.azurenative.apimanagement.WorkspaceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceGroup = new WorkspaceGroup("workspaceGroup", WorkspaceGroupArgs.builder()
 *             .description("new group to test")
 *             .displayName("NewGroup (samiraad.onmicrosoft.com)")
 *             .externalId("aad://samiraad.onmicrosoft.com/groups/83cf2753-5831-4675-bc0e-2f8dc067c58d")
 *             .groupId("aadGroup")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .type("external")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceGroup aadGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/groups/{groupId}
 * ```
 */
public class WorkspaceGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.WorkspaceGroup,
) : KotlinCustomResource(javaResource, WorkspaceGroupMapper) {
    /**
     * true if the group is one of the three system groups (Administrators, Developers, or Guests); otherwise false.
     */
    public val builtIn: Output<Boolean>
        get() = javaResource.builtIn().applyValue({ args0 -> args0 })

    /**
     * Group description. Can contain HTML formatting tags.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Group name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * For external groups, this property contains the id of the group from the external identity provider, e.g. for Azure Active Directory `aad://<tenant>.onmicrosoft.com/groups/<group object id>`; otherwise the value is null.
     */
    public val externalId: Output<String>?
        get() = javaResource.externalId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceGroupMapper : ResourceMapper<WorkspaceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspaceGroup::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceGroup = WorkspaceGroup(
        javaResource as
            com.pulumi.azurenative.apimanagement.WorkspaceGroup,
    )
}

/**
 * @see [WorkspaceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceGroup].
 */
public suspend fun workspaceGroup(
    name: String,
    block: suspend WorkspaceGroupResourceBuilder.() -> Unit,
): WorkspaceGroup {
    val builder = WorkspaceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceGroup(name: String): WorkspaceGroup {
    val builder = WorkspaceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
