@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceNotificationRecipientUser].
 */
@PulumiTagMarker
public class WorkspaceNotificationRecipientUserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceNotificationRecipientUserArgs = WorkspaceNotificationRecipientUserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceNotificationRecipientUserArgsBuilder.() -> Unit) {
        val builder = WorkspaceNotificationRecipientUserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspaceNotificationRecipientUser {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientUser(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceNotificationRecipientUser(builtJavaResource)
    }
}

/**
 * Recipient User details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspaceNotificationRecipientUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceNotificationRecipientUser = new AzureNative.ApiManagement.WorkspaceNotificationRecipientUser("workspaceNotificationRecipientUser", new()
 *     {
 *         NotificationName = "RequestPublisherNotificationMessage",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         UserId = "576823d0a40f7e74ec07d642",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspaceNotificationRecipientUser(ctx, "workspaceNotificationRecipientUser", &apimanagement.WorkspaceNotificationRecipientUserArgs{
 * 			NotificationName:  pulumi.String("RequestPublisherNotificationMessage"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			UserId:            pulumi.String("576823d0a40f7e74ec07d642"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientUser;
 * import com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceNotificationRecipientUser = new WorkspaceNotificationRecipientUser("workspaceNotificationRecipientUser", WorkspaceNotificationRecipientUserArgs.builder()
 *             .notificationName("RequestPublisherNotificationMessage")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .userId("576823d0a40f7e74ec07d642")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspaceNotificationRecipientUser 576823d0a40f7e74ec07d642 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/notifications/{notificationName}/recipientUsers/{userId}
 * ```
 */
public class WorkspaceNotificationRecipientUser internal constructor(
    override val javaResource:
    com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientUser,
) : KotlinCustomResource(javaResource, WorkspaceNotificationRecipientUserMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * API Management UserId subscribed to notification.
     */
    public val userId: Output<String>?
        get() = javaResource.userId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object WorkspaceNotificationRecipientUserMapper :
    ResourceMapper<WorkspaceNotificationRecipientUser> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientUser::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceNotificationRecipientUser =
        WorkspaceNotificationRecipientUser(
            javaResource as
                com.pulumi.azurenative.apimanagement.WorkspaceNotificationRecipientUser,
        )
}

/**
 * @see [WorkspaceNotificationRecipientUser].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceNotificationRecipientUser].
 */
public suspend fun workspaceNotificationRecipientUser(
    name: String,
    block: suspend WorkspaceNotificationRecipientUserResourceBuilder.() -> Unit,
):
    WorkspaceNotificationRecipientUser {
    val builder = WorkspaceNotificationRecipientUserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceNotificationRecipientUser].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceNotificationRecipientUser(name: String): WorkspaceNotificationRecipientUser {
    val builder = WorkspaceNotificationRecipientUserResourceBuilder()
    builder.name(name)
    return builder.build()
}
