@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspacePolicyFragment].
 */
@PulumiTagMarker
public class WorkspacePolicyFragmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspacePolicyFragmentArgs = WorkspacePolicyFragmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspacePolicyFragmentArgsBuilder.() -> Unit) {
        val builder = WorkspacePolicyFragmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WorkspacePolicyFragment {
        val builtJavaResource =
            com.pulumi.azurenative.apimanagement.WorkspacePolicyFragment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspacePolicyFragment(builtJavaResource)
    }
}

/**
 * Policy fragment contract details.
 * Azure REST API version: 2022-09-01-preview.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### ApiManagementCreateWorkspacePolicyFragment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspacePolicyFragment = new AzureNative.ApiManagement.WorkspacePolicyFragment("workspacePolicyFragment", new()
 *     {
 *         Description = "A policy fragment example",
 *         Format = "xml",
 *         Id = "policyFragment1",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *         Value = "<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>",
 *         WorkspaceId = "wks1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/apimanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apimanagement.NewWorkspacePolicyFragment(ctx, "workspacePolicyFragment", &apimanagement.WorkspacePolicyFragmentArgs{
 * 			Description:       pulumi.String("A policy fragment example"),
 * 			Format:            pulumi.String("xml"),
 * 			Id:                pulumi.String("policyFragment1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 			Value:             pulumi.String("<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>"),
 * 			WorkspaceId:       pulumi.String("wks1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicyFragment;
 * import com.pulumi.azurenative.apimanagement.WorkspacePolicyFragmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspacePolicyFragment = new WorkspacePolicyFragment("workspacePolicyFragment", WorkspacePolicyFragmentArgs.builder()
 *             .description("A policy fragment example")
 *             .format("xml")
 *             .id("policyFragment1")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .value("<fragment><json-to-xml apply=\"always\" consider-accept-header=\"false\" /></fragment>")
 *             .workspaceId("wks1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:apimanagement:WorkspacePolicyFragment policyFragment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/workspaces/{workspaceId}/policyFragments/{id}
 * ```
 */
public class WorkspacePolicyFragment internal constructor(
    override val javaResource: com.pulumi.azurenative.apimanagement.WorkspacePolicyFragment,
) : KotlinCustomResource(javaResource, WorkspacePolicyFragmentMapper) {
    /**
     * Policy fragment description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Format of the policy fragment content.
     */
    public val format: Output<String>?
        get() = javaResource.format().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Contents of the policy fragment.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object WorkspacePolicyFragmentMapper : ResourceMapper<WorkspacePolicyFragment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.apimanagement.WorkspacePolicyFragment::class == javaResource::class

    override fun map(javaResource: Resource): WorkspacePolicyFragment =
        WorkspacePolicyFragment(
            javaResource as
                com.pulumi.azurenative.apimanagement.WorkspacePolicyFragment,
        )
}

/**
 * @see [WorkspacePolicyFragment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspacePolicyFragment].
 */
public suspend fun workspacePolicyFragment(
    name: String,
    block: suspend WorkspacePolicyFragmentResourceBuilder.() -> Unit,
): WorkspacePolicyFragment {
    val builder = WorkspacePolicyFragmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspacePolicyFragment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspacePolicyFragment(name: String): WorkspacePolicyFragment {
    val builder = WorkspacePolicyFragmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
