@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
 */
public enum class ApimIdentityType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.ApimIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.ApimIdentityType> {
    SystemAssigned(com.pulumi.azurenative.apimanagement.enums.ApimIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.apimanagement.enums.ApimIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.apimanagement.enums.ApimIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.apimanagement.enums.ApimIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.ApimIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.ApimIdentityType):
            ApimIdentityType = ApimIdentityType.values().first { it.javaValue == javaType }
    }
}
