@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Form of an authorization grant, which the client uses to request the access token.
 */
public enum class BearerTokenSendingMethods(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.BearerTokenSendingMethods,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.BearerTokenSendingMethods> {
    /**
     * Access token will be transmitted in the Authorization header using Bearer schema
     */
    AuthorizationHeader(com.pulumi.azurenative.apimanagement.enums.BearerTokenSendingMethods.AuthorizationHeader),

    /**
     * Access token will be transmitted as query parameters.
     */
    Query(com.pulumi.azurenative.apimanagement.enums.BearerTokenSendingMethods.Query),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.BearerTokenSendingMethods =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.BearerTokenSendingMethods):
            BearerTokenSendingMethods =
            BearerTokenSendingMethods.values().first { it.javaValue == javaType }
    }
}
