@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sampling type.
 */
public enum class SamplingType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.SamplingType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.SamplingType> {
    /**
     * Fixed-rate sampling.
     */
    Fixed(com.pulumi.azurenative.apimanagement.enums.SamplingType.Fixed),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.SamplingType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.SamplingType):
            SamplingType = SamplingType.values().first { it.javaValue == javaType }
    }
}
