@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of the Sku.
 */
public enum class SkuType(
    public val javaValue: com.pulumi.azurenative.apimanagement.enums.SkuType,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.enums.SkuType> {
    /**
     * Developer SKU of Api Management.
     */
    Developer(com.pulumi.azurenative.apimanagement.enums.SkuType.Developer),

    /**
     * Standard SKU of Api Management.
     */
    Standard(com.pulumi.azurenative.apimanagement.enums.SkuType.Standard),

    /**
     * Premium SKU of Api Management.
     */
    Premium(com.pulumi.azurenative.apimanagement.enums.SkuType.Premium),

    /**
     * Basic SKU of Api Management.
     */
    Basic(com.pulumi.azurenative.apimanagement.enums.SkuType.Basic),

    /**
     * Consumption SKU of Api Management.
     */
    Consumption(com.pulumi.azurenative.apimanagement.enums.SkuType.Consumption),

    /**
     * Isolated SKU of Api Management.
     */
    Isolated(com.pulumi.azurenative.apimanagement.enums.SkuType.Isolated),
    ;

    override fun toJava(): com.pulumi.azurenative.apimanagement.enums.SkuType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.enums.SkuType): SkuType =
            SkuType.values().first { it.javaValue == javaType }
    }
}
