@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.AdditionalLocationArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.NatGatewayState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Description of an additional API Management resource location.
 * @property disableGateway Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
 * @property location The location name of the additional region among Azure Data center regions.
 * @property natGatewayState Property can be used to enable NAT Gateway for this API Management service.
 * @property publicIpAddressId Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the location. Supported only for Premium SKU being deployed in Virtual Network.
 * @property sku SKU properties of the API Management service.
 * @property virtualNetworkConfiguration Virtual network configuration for the location.
 * @property zones A list of availability zones denoting where the resource needs to come from.
 */
public data class AdditionalLocationArgs(
    public val disableGateway: Output<Boolean>? = null,
    public val location: Output<String>,
    public val natGatewayState: Output<Either<String, NatGatewayState>>? = null,
    public val publicIpAddressId: Output<String>? = null,
    public val sku: Output<ApiManagementServiceSkuPropertiesArgs>,
    public val virtualNetworkConfiguration: Output<VirtualNetworkConfigurationArgs>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.AdditionalLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.AdditionalLocationArgs =
        com.pulumi.azurenative.apimanagement.inputs.AdditionalLocationArgs.builder()
            .disableGateway(disableGateway?.applyValue({ args0 -> args0 }))
            .location(location.applyValue({ args0 -> args0 }))
            .natGatewayState(
                natGatewayState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicIpAddressId(publicIpAddressId?.applyValue({ args0 -> args0 }))
            .sku(sku.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualNetworkConfiguration(
                virtualNetworkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AdditionalLocationArgs].
 */
@PulumiTagMarker
public class AdditionalLocationArgsBuilder internal constructor() {
    private var disableGateway: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var natGatewayState: Output<Either<String, NatGatewayState>>? = null

    private var publicIpAddressId: Output<String>? = null

    private var sku: Output<ApiManagementServiceSkuPropertiesArgs>? = null

    private var virtualNetworkConfiguration: Output<VirtualNetworkConfigurationArgs>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
     */
    @JvmName("cjsvskxxmjlehjxx")
    public suspend fun disableGateway(`value`: Output<Boolean>) {
        this.disableGateway = value
    }

    /**
     * @param value The location name of the additional region among Azure Data center regions.
     */
    @JvmName("ebfvhigmbckeokhs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Property can be used to enable NAT Gateway for this API Management service.
     */
    @JvmName("bijfyhicwljhqsuv")
    public suspend fun natGatewayState(`value`: Output<Either<String, NatGatewayState>>) {
        this.natGatewayState = value
    }

    /**
     * @param value Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the location. Supported only for Premium SKU being deployed in Virtual Network.
     */
    @JvmName("cldcyejknjwqfprg")
    public suspend fun publicIpAddressId(`value`: Output<String>) {
        this.publicIpAddressId = value
    }

    /**
     * @param value SKU properties of the API Management service.
     */
    @JvmName("duqlckjuenwwpoen")
    public suspend fun sku(`value`: Output<ApiManagementServiceSkuPropertiesArgs>) {
        this.sku = value
    }

    /**
     * @param value Virtual network configuration for the location.
     */
    @JvmName("fvrjmejaegnluaha")
    public suspend fun virtualNetworkConfiguration(`value`: Output<VirtualNetworkConfigurationArgs>) {
        this.virtualNetworkConfiguration = value
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("egvfvytxmnwnulld")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("spstnmpcrynoxcrk")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("kfmgcuwnyyupkjbl")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
     */
    @JvmName("rcctkphsoovgubkp")
    public suspend fun disableGateway(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableGateway = mapped
    }

    /**
     * @param value The location name of the additional region among Azure Data center regions.
     */
    @JvmName("hvdgmnjhqsloluiu")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Property can be used to enable NAT Gateway for this API Management service.
     */
    @JvmName("csjfapgvhntfwqfy")
    public suspend fun natGatewayState(`value`: Either<String, NatGatewayState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayState = mapped
    }

    /**
     * @param value Property can be used to enable NAT Gateway for this API Management service.
     */
    @JvmName("plangixuksekdncn")
    public fun natGatewayState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NatGatewayState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.natGatewayState = mapped
    }

    /**
     * @param value Property can be used to enable NAT Gateway for this API Management service.
     */
    @JvmName("nawfcxdiorynlelb")
    public fun natGatewayState(`value`: NatGatewayState) {
        val toBeMapped = Either.ofRight<String, NatGatewayState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.natGatewayState = mapped
    }

    /**
     * @param value Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the location. Supported only for Premium SKU being deployed in Virtual Network.
     */
    @JvmName("bfovqrjndqmqyvtd")
    public suspend fun publicIpAddressId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddressId = mapped
    }

    /**
     * @param value SKU properties of the API Management service.
     */
    @JvmName("jykmmmmmrrqknanr")
    public suspend fun sku(`value`: ApiManagementServiceSkuPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU properties of the API Management service.
     */
    @JvmName("bvnrgosqgejxujld")
    public suspend
    fun sku(argument: suspend ApiManagementServiceSkuPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApiManagementServiceSkuPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Virtual network configuration for the location.
     */
    @JvmName("apcwgvmwvbujtsgj")
    public suspend fun virtualNetworkConfiguration(`value`: VirtualNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkConfiguration = mapped
    }

    /**
     * @param argument Virtual network configuration for the location.
     */
    @JvmName("cwapqysshjvooxxc")
    public suspend
    fun virtualNetworkConfiguration(argument: suspend VirtualNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkConfiguration = mapped
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("duxgonmcwvgxxoks")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("ssoylpefhnrfrlbt")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): AdditionalLocationArgs = AdditionalLocationArgs(
        disableGateway = disableGateway,
        location = location ?: throw PulumiNullFieldException("location"),
        natGatewayState = natGatewayState,
        publicIpAddressId = publicIpAddressId,
        sku = sku ?: throw PulumiNullFieldException("sku"),
        virtualNetworkConfiguration = virtualNetworkConfiguration,
        zones = zones,
    )
}
