@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Criteria to limit import of WSDL to a subset of the document.
 * @property wsdlEndpointName Name of endpoint(port) to import from WSDL
 * @property wsdlServiceName Name of service to import from WSDL
 */
public data class ApiCreateOrUpdatePropertiesWsdlSelectorArgs(
    public val wsdlEndpointName: Output<String>? = null,
    public val wsdlServiceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs =
        com.pulumi.azurenative.apimanagement.inputs.ApiCreateOrUpdatePropertiesWsdlSelectorArgs.builder()
            .wsdlEndpointName(wsdlEndpointName?.applyValue({ args0 -> args0 }))
            .wsdlServiceName(wsdlServiceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiCreateOrUpdatePropertiesWsdlSelectorArgs].
 */
@PulumiTagMarker
public class ApiCreateOrUpdatePropertiesWsdlSelectorArgsBuilder internal constructor() {
    private var wsdlEndpointName: Output<String>? = null

    private var wsdlServiceName: Output<String>? = null

    /**
     * @param value Name of endpoint(port) to import from WSDL
     */
    @JvmName("daxqwiuuhlmheava")
    public suspend fun wsdlEndpointName(`value`: Output<String>) {
        this.wsdlEndpointName = value
    }

    /**
     * @param value Name of service to import from WSDL
     */
    @JvmName("pepylwautdpckdxg")
    public suspend fun wsdlServiceName(`value`: Output<String>) {
        this.wsdlServiceName = value
    }

    /**
     * @param value Name of endpoint(port) to import from WSDL
     */
    @JvmName("lqiebiqbdqhsuimk")
    public suspend fun wsdlEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wsdlEndpointName = mapped
    }

    /**
     * @param value Name of service to import from WSDL
     */
    @JvmName("wedjehhmdnslyxqt")
    public suspend fun wsdlServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wsdlServiceName = mapped
    }

    internal fun build(): ApiCreateOrUpdatePropertiesWsdlSelectorArgs =
        ApiCreateOrUpdatePropertiesWsdlSelectorArgs(
            wsdlEndpointName = wsdlEndpointName,
            wsdlServiceName = wsdlServiceName,
        )
}
