@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceIdentityArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.ApimIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Identity properties of the Api Management service resource.
 * @property type The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
 * @property userAssignedIdentities The list of user identities associated with the resource. The user identity
 * dictionary key references will be ARM resource ids in the form:
 * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
 *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class ApiManagementServiceIdentityArgs(
    public val type: Output<Either<String, ApimIdentityType>>,
    public val userAssignedIdentities: Output<Map<String, UserIdentityPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceIdentityArgs =
        com.pulumi.azurenative.apimanagement.inputs.ApiManagementServiceIdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApiManagementServiceIdentityArgs].
 */
@PulumiTagMarker
public class ApiManagementServiceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ApimIdentityType>>? = null

    private var userAssignedIdentities: Output<Map<String, UserIdentityPropertiesArgs>>? = null

    /**
     * @param value The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
     */
    @JvmName("sntbrfjnmsossdih")
    public suspend fun type(`value`: Output<Either<String, ApimIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("pnqagugmtathbewi")
    public suspend
    fun userAssignedIdentities(`value`: Output<Map<String, UserIdentityPropertiesArgs>>) {
        this.userAssignedIdentities = value
    }

    /**
     * @param value The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
     */
    @JvmName("rfwtuashxtddvjxt")
    public suspend fun type(`value`: Either<String, ApimIdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
     */
    @JvmName("nrtjpvqvxeilbgts")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApimIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
     */
    @JvmName("poggpcmlalsbgyaj")
    public fun type(`value`: ApimIdentityType) {
        val toBeMapped = Either.ofRight<String, ApimIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("ioetsqsgvupvibbk")
    public suspend fun userAssignedIdentities(`value`: Map<String, UserIdentityPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("cdbaftedveemqmvx")
    public suspend fun userAssignedIdentities(
        vararg
        argument: Pair<String, suspend UserIdentityPropertiesArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserIdentityPropertiesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     *     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("jilkgcbroeqtoxnr")
    public fun userAssignedIdentities(vararg values: Pair<String, UserIdentityPropertiesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ApiManagementServiceIdentityArgs = ApiManagementServiceIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
