@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API Authentication Settings.
 * @property oAuth2 OAuth2 Authentication settings
 * @property oAuth2AuthenticationSettings Collection of OAuth2 authentication settings included into this API.
 * @property openid OpenID Connect Authentication Settings
 * @property openidAuthenticationSettings Collection of Open ID Connect authentication settings included into this API.
 */
public data class AuthenticationSettingsContractArgs(
    public val oAuth2: Output<OAuth2AuthenticationSettingsContractArgs>? = null,
    public val oAuth2AuthenticationSettings: Output<List<OAuth2AuthenticationSettingsContractArgs>>? =
        null,
    public val openid: Output<OpenIdAuthenticationSettingsContractArgs>? = null,
    public val openidAuthenticationSettings: Output<List<OpenIdAuthenticationSettingsContractArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.AuthenticationSettingsContractArgs.builder()
            .oAuth2(oAuth2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .oAuth2AuthenticationSettings(
                oAuth2AuthenticationSettings?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .openid(openid?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .openidAuthenticationSettings(
                openidAuthenticationSettings?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [AuthenticationSettingsContractArgs].
 */
@PulumiTagMarker
public class AuthenticationSettingsContractArgsBuilder internal constructor() {
    private var oAuth2: Output<OAuth2AuthenticationSettingsContractArgs>? = null

    private var oAuth2AuthenticationSettings: Output<List<OAuth2AuthenticationSettingsContractArgs>>? =
        null

    private var openid: Output<OpenIdAuthenticationSettingsContractArgs>? = null

    private var openidAuthenticationSettings: Output<List<OpenIdAuthenticationSettingsContractArgs>>? =
        null

    /**
     * @param value OAuth2 Authentication settings
     */
    @JvmName("behyvwevwjjjohtm")
    public suspend fun oAuth2(`value`: Output<OAuth2AuthenticationSettingsContractArgs>) {
        this.oAuth2 = value
    }

    /**
     * @param value Collection of OAuth2 authentication settings included into this API.
     */
    @JvmName("kvembybgtkugginp")
    public suspend
    fun oAuth2AuthenticationSettings(`value`: Output<List<OAuth2AuthenticationSettingsContractArgs>>) {
        this.oAuth2AuthenticationSettings = value
    }

    @JvmName("qofytnhwxsjmslvc")
    public suspend fun oAuth2AuthenticationSettings(
        vararg
        values: Output<OAuth2AuthenticationSettingsContractArgs>,
    ) {
        this.oAuth2AuthenticationSettings = Output.all(values.asList())
    }

    /**
     * @param values Collection of OAuth2 authentication settings included into this API.
     */
    @JvmName("pxgvnlorvquqclhj")
    public suspend
    fun oAuth2AuthenticationSettings(values: List<Output<OAuth2AuthenticationSettingsContractArgs>>) {
        this.oAuth2AuthenticationSettings = Output.all(values)
    }

    /**
     * @param value OpenID Connect Authentication Settings
     */
    @JvmName("pyaarmbhckblhjag")
    public suspend fun openid(`value`: Output<OpenIdAuthenticationSettingsContractArgs>) {
        this.openid = value
    }

    /**
     * @param value Collection of Open ID Connect authentication settings included into this API.
     */
    @JvmName("odcfjwrlrftegrkm")
    public suspend
    fun openidAuthenticationSettings(`value`: Output<List<OpenIdAuthenticationSettingsContractArgs>>) {
        this.openidAuthenticationSettings = value
    }

    @JvmName("fpcfmfbkwjxkbgha")
    public suspend fun openidAuthenticationSettings(
        vararg
        values: Output<OpenIdAuthenticationSettingsContractArgs>,
    ) {
        this.openidAuthenticationSettings = Output.all(values.asList())
    }

    /**
     * @param values Collection of Open ID Connect authentication settings included into this API.
     */
    @JvmName("tgurtbxmctsupyfk")
    public suspend
    fun openidAuthenticationSettings(values: List<Output<OpenIdAuthenticationSettingsContractArgs>>) {
        this.openidAuthenticationSettings = Output.all(values)
    }

    /**
     * @param value OAuth2 Authentication settings
     */
    @JvmName("yulpygkcyhkdtrbw")
    public suspend fun oAuth2(`value`: OAuth2AuthenticationSettingsContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oAuth2 = mapped
    }

    /**
     * @param argument OAuth2 Authentication settings
     */
    @JvmName("xhkamxgldpxvjmsb")
    public suspend
    fun oAuth2(argument: suspend OAuth2AuthenticationSettingsContractArgsBuilder.() -> Unit) {
        val toBeMapped = OAuth2AuthenticationSettingsContractArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.oAuth2 = mapped
    }

    /**
     * @param value Collection of OAuth2 authentication settings included into this API.
     */
    @JvmName("uehbyxdjktvqicei")
    public suspend
    fun oAuth2AuthenticationSettings(`value`: List<OAuth2AuthenticationSettingsContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oAuth2AuthenticationSettings = mapped
    }

    /**
     * @param argument Collection of OAuth2 authentication settings included into this API.
     */
    @JvmName("iovdbinekbuhisvn")
    public suspend
    fun oAuth2AuthenticationSettings(argument: List<suspend OAuth2AuthenticationSettingsContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OAuth2AuthenticationSettingsContractArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.oAuth2AuthenticationSettings = mapped
    }

    /**
     * @param argument Collection of OAuth2 authentication settings included into this API.
     */
    @JvmName("udrdplagiturddhr")
    public suspend fun oAuth2AuthenticationSettings(
        vararg
        argument: suspend OAuth2AuthenticationSettingsContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OAuth2AuthenticationSettingsContractArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.oAuth2AuthenticationSettings = mapped
    }

    /**
     * @param argument Collection of OAuth2 authentication settings included into this API.
     */
    @JvmName("ycpqkompqfgtcwgx")
    public suspend
    fun oAuth2AuthenticationSettings(argument: suspend OAuth2AuthenticationSettingsContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OAuth2AuthenticationSettingsContractArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.oAuth2AuthenticationSettings = mapped
    }

    /**
     * @param values Collection of OAuth2 authentication settings included into this API.
     */
    @JvmName("dnnvtjglredgyafr")
    public suspend fun oAuth2AuthenticationSettings(
        vararg
        values: OAuth2AuthenticationSettingsContractArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oAuth2AuthenticationSettings = mapped
    }

    /**
     * @param value OpenID Connect Authentication Settings
     */
    @JvmName("yseeuenwvonannmi")
    public suspend fun openid(`value`: OpenIdAuthenticationSettingsContractArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openid = mapped
    }

    /**
     * @param argument OpenID Connect Authentication Settings
     */
    @JvmName("dpccgatpuaxgnyup")
    public suspend
    fun openid(argument: suspend OpenIdAuthenticationSettingsContractArgsBuilder.() -> Unit) {
        val toBeMapped = OpenIdAuthenticationSettingsContractArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.openid = mapped
    }

    /**
     * @param value Collection of Open ID Connect authentication settings included into this API.
     */
    @JvmName("mixseljdittlmmbu")
    public suspend
    fun openidAuthenticationSettings(`value`: List<OpenIdAuthenticationSettingsContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openidAuthenticationSettings = mapped
    }

    /**
     * @param argument Collection of Open ID Connect authentication settings included into this API.
     */
    @JvmName("tyteecllpmfsnavu")
    public suspend
    fun openidAuthenticationSettings(argument: List<suspend OpenIdAuthenticationSettingsContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenIdAuthenticationSettingsContractArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.openidAuthenticationSettings = mapped
    }

    /**
     * @param argument Collection of Open ID Connect authentication settings included into this API.
     */
    @JvmName("aqseqmvlnesaqsgk")
    public suspend fun openidAuthenticationSettings(
        vararg
        argument: suspend OpenIdAuthenticationSettingsContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OpenIdAuthenticationSettingsContractArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.openidAuthenticationSettings = mapped
    }

    /**
     * @param argument Collection of Open ID Connect authentication settings included into this API.
     */
    @JvmName("kglikirpaodgndii")
    public suspend
    fun openidAuthenticationSettings(argument: suspend OpenIdAuthenticationSettingsContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OpenIdAuthenticationSettingsContractArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.openidAuthenticationSettings = mapped
    }

    /**
     * @param values Collection of Open ID Connect authentication settings included into this API.
     */
    @JvmName("kotgvuitfykcqwnt")
    public suspend fun openidAuthenticationSettings(
        vararg
        values: OpenIdAuthenticationSettingsContractArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.openidAuthenticationSettings = mapped
    }

    internal fun build(): AuthenticationSettingsContractArgs = AuthenticationSettingsContractArgs(
        oAuth2 = oAuth2,
        oAuth2AuthenticationSettings = oAuth2AuthenticationSettings,
        openid = openid,
        openidAuthenticationSettings = openidAuthenticationSettings,
    )
}
